/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.map;

import de.berlin.hu.wbi.common.map.HashByteMap;
import de.berlin.hu.wbi.common.map.PrimitiveMap;
import java.util.Arrays;

public class ArrayCharMap
implements PrimitiveMap {
    private static final long serialVersionUID = -4919654141469909707L;
    int i;
    char[] keys;
    int[] values;

    @Override
    public void setValue(int value) {
        if (this.i > -1) {
            this.values[this.i] = value;
        }
    }

    @Override
    public int getValue() {
        if (this.i < 0) {
            return 0;
        }
        return this.values[this.i];
    }

    @Override
    public int getSize() {
        return this.keys.length;
    }

    @Override
    public void addAll(PrimitiveMap map) {
        int size = map.getSize();
        this.keys = new char[size];
        this.values = new int[size];
        int[] sourceKeys = map.getKeys();
        Arrays.sort(sourceKeys);
        for (int i = 0; i < sourceKeys.length; ++i) {
            int key = sourceKeys[i];
            map.containsKey(key);
            int value = map.getValue();
            this.keys[i] = (char)key;
            this.values[i] = value;
        }
    }

    public static void main(String[] args) {
        HashByteMap map = new HashByteMap();
        map.put((byte)1, 17);
        map.put((byte)-120, 6);
        map.put((byte)-24, 3563);
        map.put((byte)96, -254);
        System.out.println(Arrays.toString(map.getValues()));
        ArrayCharMap m = new ArrayCharMap();
        m.addAll(map);
        System.out.println(m.containsKey(1));
        System.out.println(m.getValue());
        System.out.println(m.containsKey(2));
        System.out.println(m.getValue());
        System.out.println(m.containsKey(-24));
        System.out.println(m.getValue());
        System.out.println(Arrays.toString(m.getKeys()));
        System.out.println(Arrays.toString(m.getValues()));
    }

    @Override
    public int[] getKeys() {
        int[] buffer = new int[this.keys.length];
        for (int i = 0; i < this.keys.length; ++i) {
            buffer[i] = this.keys[i];
        }
        return buffer;
    }

    @Override
    public boolean containsKey(int key) {
        this.i = Arrays.binarySearch(this.keys, (char)key);
        return this.i > -1;
    }

    @Override
    public int getValue(int key) {
        this.containsKey(key);
        return this.getValue();
    }

    @Override
    public int[] getValues() {
        return this.values;
    }
}

