/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.io;

import de.berlin.hu.wbi.common.layer.InputStreamLayer;
import de.berlin.hu.wbi.common.layer.TextLayer;
import de.berlin.hu.wbi.common.xml.XmlKit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class WbiXmlReader
implements InputStreamLayer,
TextLayer {
    private XMLReader xmlReader = XMLReaderFactory.createXMLReader();
    private Matcher errorMatcher = Pattern.compile("(.*)(\\s)([(]).*").matcher("");
    private File file;

    public XMLReader getXmlReader() {
        return this.xmlReader;
    }

    public void pushInputSourceSource(InputSourceSource streamable) {
        try {
            try {
                this.xmlReader.parse(streamable.getInputSource());
            }
            catch (FileNotFoundException e) {
                this.handleException(e);
                this.pushInputSourceSource(streamable);
            }
        }
        catch (Exception e) {
            new RuntimeException(e);
        }
    }

    public void pushInputSource(InputSource input) throws Throwable {
        try {
            this.xmlReader.parse(input);
        }
        catch (FileNotFoundException e) {
            if (this.handleException(e)) {
                this.pushInputSource(input);
            }
            throw e;
        }
    }

    public void pushSystemId(String systemId) throws Throwable {
        this.pushInputSource(new InputSource(systemId));
    }

    public boolean handleException(FileNotFoundException e) throws IOException {
        String message = e.getMessage();
        System.out.println(message);
        this.errorMatcher.reset(message);
        if (this.errorMatcher.matches()) {
            String path = this.errorMatcher.group(1);
            this.file = new File(path);
            this.file.getParentFile().mkdirs();
            this.file.createNewFile();
            this.file.deleteOnExit();
            System.err.println("Created temporary file: " + this.file.getCanonicalPath());
            return true;
        }
        return false;
    }

    public void pushText(CharSequence text) throws Throwable {
        InputSource input = XmlKit.getInputSource(text);
        this.pushInputSource(input);
    }

    public void pushInputStream(InputStream input) throws Exception {
        this.xmlReader.parse(new InputSource(input));
    }

    public void connect(DefaultHandler handler) {
        this.xmlReader.setContentHandler(handler);
    }

    public static interface InputSourceSource {
        public InputSource getInputSource();
    }
}

