/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.io;

import de.berlin.hu.wbi.common.layer.EntityHandler;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Date;

public class TabularPrinter
implements EntityHandler<Object> {
    private PrintStream stream;
    private int columnCount;
    private String separator;
    private long elementCount = 0L;

    public TabularPrinter(PrintStream stream, int columnCount, Object seperator) throws FileNotFoundException {
        this.stream = stream;
        this.columnCount = columnCount;
        this.separator = seperator.toString();
    }

    public TabularPrinter(PrintStream stream, int columnCount) throws FileNotFoundException {
        this(stream, columnCount, "\t");
    }

    public static void main(String[] args) throws FileNotFoundException {
        PrintStream out = System.out;
        int columns = 4;
        Character s = Character.valueOf('\t');
        TabularPrinter o = new TabularPrinter(out, columns, s);
        o.handleEntity((Object)1);
        o.handleEntity("Hallo");
        o.handleEntity(new Date());
        o.handleEntity(Character.valueOf('a'));
        o.handleEntity((Object)Math.PI);
    }

    @Override
    public void handleEntity(Object entity) {
        ++this.elementCount;
        this.stream.print(entity);
        if (this.elementCount % (long)this.columnCount == 0L) {
            this.stream.println();
        } else {
            this.stream.print(this.separator);
        }
    }
}

