/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.io;

import de.berlin.hu.wbi.common.io.CharArrayInputStreamLayer;
import de.berlin.hu.wbi.common.io.IO;
import de.berlin.hu.wbi.common.layer.CharArrayHandler;
import de.berlin.hu.wbi.common.layer.InputStreamHandler;
import de.berlin.hu.wbi.common.layer.NewLineHandler;
import de.berlin.hu.wbi.common.layer.TextHandler;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LineExtractor
implements CharArrayHandler,
InputStreamHandler,
TextHandler,
NewLineHandler {
    private TextHandler layer;
    private StringBuilder b = new StringBuilder();
    private CharArrayInputStreamLayer i;
    private Matcher matcher;

    public LineExtractor() {
        String regex = "\n";
        this.matcher = Pattern.compile(regex).matcher("");
    }

    public void connect(TextHandler layer) {
        this.layer = layer;
    }

    @Override
    public void handleCharArray(char[] array, int offset, int count) {
        this.b.append(array, offset, count);
    }

    @Override
    public void handleNewLine() throws Throwable {
        this.layer.handleText(this.b);
        this.b.setLength(0);
    }

    public void pushInputStream(String locator) throws Throwable {
        InputStream input = IO.open(locator);
        this.handleInputStream(input);
    }

    @Override
    public void handleInputStream(InputStream input) throws Throwable {
        if (this.i == null) {
            this.i = new CharArrayInputStreamLayer();
        }
        this.i.connect(this);
        this.i.connect(this);
        this.i.handleInputStream(input);
    }

    @Override
    public void handleText(CharSequence text) throws Throwable {
        int start = 0;
        this.matcher.reset(text);
        while (this.matcher.find(start)) {
            int newMatch = this.matcher.start();
            CharSequence line = text.subSequence(start, newMatch);
            this.layer.handleText(line);
            start = newMatch + 1;
        }
        CharSequence lastLine = text.subSequence(start, text.length());
        this.layer.handleText(lastLine);
    }

    public static void main(String[] args) throws Throwable {
        LineExtractor extractor = new LineExtractor();
        extractor.connect(new TextHandler(){

            @Override
            public void handleText(CharSequence text) {
                System.out.println(text);
            }
        });
        extractor.handleText("Dies\nist\nein\n\n\n\ntest\n");
    }
}

