/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.io;

import de.berlin.hu.wbi.common.io.IO;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;

public class LazyLineReader
implements Iterable<StringBuilder> {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private Reader in;
    private char[] buf;
    private int read;
    private int start;
    private int end;
    private int i;
    private StringBuilder builder;
    private Iterator<StringBuilder> iterator;

    public LazyLineReader(Reader input, int size, StringBuilder builder) {
        this.in = input;
        this.buf = new char[size];
        this.start = 0;
        this.end = 0;
        this.read = 0;
        this.i = 0;
        this.builder = builder;
    }

    public LazyLineReader(Reader reader) {
        this(reader, 8192, new StringBuilder());
    }

    public LazyLineReader(String locator) {
        this(IO.read(locator), 8192, new StringBuilder());
    }

    public int readLine() throws IOException {
        boolean lineFound = false;
        this.builder.setLength(0);
        if (this.read < 0) {
            return this.read;
        }
        while (!lineFound) {
            if (this.i == this.read) {
                this.read = this.in.read(this.buf);
                if (this.read < 0) {
                    if (this.builder.length() == 0) {
                        return this.read;
                    }
                    return this.builder.length();
                }
                this.start = 0;
                this.end = this.read;
            }
            this.i = this.start;
            while (this.i < this.read) {
                char c = this.buf[this.i];
                if (c == '\n') {
                    lineFound = true;
                    this.end = this.i - 1;
                    break;
                }
                ++this.i;
            }
            if (this.i == this.read) {
                this.end = this.i - 1;
            }
            this.builder.append(this.buf, this.start, this.end - this.start + 1);
            if (!lineFound) continue;
            this.start = this.end + 2;
        }
        return this.builder.length();
    }

    @Override
    public Iterator<StringBuilder> iterator() {
        if (this.iterator != null) {
            throw new UnsupportedOperationException("No cuncurrent/multiple iteration supported.");
        }
        this.iterator = new Iterator<StringBuilder>(){

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public StringBuilder next() {
                if (LazyLineReader.this.read >= 0) {
                    return LazyLineReader.this.builder;
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                try {
                    int readLine = LazyLineReader.this.readLine();
                    return readLine >= 0;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        return this.iterator;
    }

    public void close() throws IOException {
        this.in.close();
    }
}

