/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.io;

import de.berlin.hu.wbi.common.io.IO;
import de.berlin.hu.wbi.common.io.LazyLineReader;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class IterableBufferedReader
extends BufferedReader
implements Iterable<String> {
    Iterator<String> iterator = null;

    public IterableBufferedReader(String locator) {
        super(IO.read(locator));
    }

    public IterableBufferedReader(Reader in) {
        super(in);
    }

    public IterableBufferedReader(Reader in, int sz) {
        super(in, sz);
    }

    private void initIterator() {
        this.iterator = new Iterator<String>(){
            String next;

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    try {
                        this.next = IterableBufferedReader.this.readLine();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return this.next != null;
            }

            @Override
            public String next() {
                String output = this.next;
                try {
                    this.next = IterableBufferedReader.this.readLine();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return output;
            }

            @Override
            public void remove() {
                throw new NotImplementedException();
            }
        };
    }

    @Override
    public Iterator<String> iterator() {
        if (this.iterator != null) {
            throw new UnsupportedOperationException("No multiple/concurrent interation supported.");
        }
        this.initIterator();
        return this.iterator;
    }

    public static void main(String[] args) throws FileNotFoundException {
        String file = "/tmp/arzt/uniprot_hsa.dat";
        int c = 0;
        for (StringBuilder string : new LazyLineReader(file)) {
            System.out.println(string);
            ++c;
        }
        System.out.println(c);
    }
}

