/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class IO {
    private static final Matcher MATCHER_URL = Pattern.compile("(http://|ftp://).*").matcher("");

    public static InputStream open(String locator) {
        InputStream returnValue = null;
        if (locator != null && !locator.trim().isEmpty()) {
            File file;
            int buffer = 80000;
            returnValue = MATCHER_URL.reset(locator).matches() ? IO.fromURL(locator) : ((file = new File(locator)).exists() && file.canRead() ? IO.fromFile(file) : ClassLoader.getSystemResourceAsStream(locator));
            if (returnValue != null) {
                if (locator.toLowerCase().endsWith(".gz")) {
                    try {
                        returnValue = new GZIPInputStream(returnValue, buffer);
                    }
                    catch (Exception exception) {}
                } else {
                    returnValue = new BufferedInputStream(returnValue, buffer);
                }
            }
        }
        return returnValue;
    }

    public static BufferedReader read(String locator) {
        BufferedReader returnValue = null;
        InputStream open = IO.open(locator);
        if (open != null) {
            returnValue = new BufferedReader(new InputStreamReader(open));
        }
        return returnValue;
    }

    private static InputStream fromFile(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static InputStream fromURL(String locator) {
        InputStream output = null;
        try {
            URL url = new URL(locator);
            output = url.openStream();
        }
        catch (IOException e) {
            output = null;
        }
        return output;
    }

    public static <T> T deserialize(String filename) throws IOException, ClassNotFoundException {
        return IO.deserialize(filename, false);
    }

    public static <T> T deserialize(String filename, boolean compress) throws ClassNotFoundException, FileNotFoundException, IOException {
        FilterInputStream in = null;
        in = compress ? new GZIPInputStream((InputStream)new FileInputStream(filename), 80000) : new BufferedInputStream(new FileInputStream(filename), 80000);
        ObjectInputStream stream = new ObjectInputStream(in);
        Object object = stream.readObject();
        return (T)object;
    }

    public static void serialize(Object object, String filename) throws IOException {
        IO.serialize(object, filename, false);
    }

    public static void serialzeCompressed(Object object, String filename) throws IOException {
        IO.serialize(object, filename, true);
    }

    public static void serialize(Object object, String filename, boolean compress) throws IOException {
        if (object != null) {
            File file = new File(filename);
            if (!(file = new File(file.getAbsolutePath())).exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            OutputStream out = new FileOutputStream(filename);
            System.out.format("Serializing '%s' to '%s'.\n", object.getClass().getName(), filename);
            int bufferSize = 80000;
            out = compress ? new GZIPOutputStream(out, bufferSize) : new BufferedOutputStream(out, bufferSize);
            ObjectOutputStream stream = new ObjectOutputStream(out);
            stream.writeObject(object);
            stream.flush();
            stream.close();
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[8192];
        int read = in.read(buf);
        while (read > 0) {
            out.write(buf, 0, read);
            read = in.read(buf);
        }
    }
}

