/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.io;

import de.berlin.hu.wbi.common.misc.Timer;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Scanner;

public class FastLineCounter {
    public static int bufSize = 100000;

    public static void main(String[] args) throws IOException {
        Timer t = Timer.startTimerMilli();
        System.out.println(FastLineCounter.countLinesFast("/vol/fob-vol5/mi06/arzt/Desktop/omim/omim.txt"));
        t.print("");
    }

    public static int countOccurrences(byte[] template, byte[] pattern, int len) {
        int count = 0;
        int finish = Math.min(template.length - pattern.length + 1, len);
        for (int i = 0; i < finish; ++i) {
            int j;
            for (j = 0; j < pattern.length && template[i + j] == pattern[j]; ++j) {
            }
            if (j != pattern.length) continue;
            ++count;
        }
        return count;
    }

    public static int countOccurrences(byte[] template, byte[] pattern) {
        return FastLineCounter.countOccurrences(template, pattern, template.length);
    }

    public static MappedByteBuffer getMappedByteBuffer(String path) throws IOException {
        File file = new File(path);
        FileChannel ch = new FileInputStream(file).getChannel();
        MappedByteBuffer mb = ch.map(FileChannel.MapMode.READ_ONLY, 0L, ch.size());
        return mb;
    }

    public static int countLinesFast(String path) throws IOException {
        MappedByteBuffer mb = FastLineCounter.getMappedByteBuffer(path);
        byte[] array = new byte[bufSize];
        int count = 0;
        while (mb.hasRemaining()) {
            int n = Math.min(mb.remaining(), bufSize);
            mb.get(array, 0, n);
            count += FastLineCounter.countOccurrences(array, "\n".getBytes());
        }
        return count;
    }

    public static int countLinesSlow(String path) throws FileNotFoundException {
        Scanner scan = new Scanner(new File(path));
        int output = 0;
        while (scan.hasNextLine()) {
            ++output;
            scan.nextLine();
        }
        return output;
    }

    public static int countLinesBufferdReader(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        int count = 0;
        while (line != null) {
            line = reader.readLine();
            if (++count % 1000000 != 0) continue;
            System.out.println(count);
        }
        return count;
    }

    public static int countLinesInputStream(InputStream input) throws IOException {
        int lines = 0;
        int bufferSize = 0x6400000;
        int len = 1;
        byte[] buffer = new byte[bufferSize];
        byte[] pattern = new byte[]{10};
        input = new BufferedInputStream(input, bufferSize);
        while (len > 0) {
            len = input.read(buffer);
            lines += FastLineCounter.countOccurrences(buffer, pattern, len);
        }
        return lines;
    }

    public static int countLinesScanner(InputStream stream) {
        Scanner scan = new Scanner(stream);
        int output = 0;
        while (scan.hasNextLine()) {
            ++output;
            scan.nextLine();
        }
        return output;
    }
}

