/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.io;

import de.berlin.hu.wbi.common.io.IO;
import de.berlin.hu.wbi.common.io.LineExtractor;
import de.berlin.hu.wbi.common.layer.CharArrayHandler;
import de.berlin.hu.wbi.common.layer.InputStreamHandler;
import de.berlin.hu.wbi.common.layer.NewLineHandler;
import de.berlin.hu.wbi.common.layer.TextHandler;
import java.io.InputStream;
import java.io.InputStreamReader;

public class CharArrayInputStreamLayer
implements InputStreamHandler {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private char[] buf;
    private CharArrayHandler charArrayLayer;
    private NewLineHandler newLineLayer;

    public CharArrayInputStreamLayer(char[] buf) {
        this.buf = buf;
    }

    public CharArrayInputStreamLayer(int size) {
        this.buf = new char[size];
    }

    public CharArrayInputStreamLayer() {
        this.buf = new char[8192];
    }

    public void connect(CharArrayHandler layer) {
        this.charArrayLayer = layer;
    }

    public void connect(NewLineHandler layer) {
        this.newLineLayer = layer;
    }

    @Override
    public void handleInputStream(InputStream input) throws Throwable {
        InputStreamReader in = new InputStreamReader(input);
        int read = in.read(this.buf);
        while (read >= 0) {
            int start = 0;
            for (int i = 0; i < read; ++i) {
                if (this.buf[i] != '\n') continue;
                this.charArrayLayer.handleCharArray(this.buf, start, i - start);
                this.newLineLayer.handleNewLine();
                start = i + 1;
            }
            this.charArrayLayer.handleCharArray(this.buf, start, read - start);
            read = in.read(this.buf);
        }
    }

    public static void main(String[] args) throws Throwable {
        InputStream stream = IO.open("/vol/fob-vol5/mi06/arzt/Desktop/Example.java");
        LineExtractor a = new LineExtractor();
        TextHandler layer = new TextHandler(){

            @Override
            public void handleText(CharSequence line) {
                System.out.println("ahhlo: " + line);
            }
        };
        a.connect(layer);
        a.handleInputStream(stream);
    }
}

