/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.filter;

import de.berlin.hu.wbi.common.collection.Lists;
import de.berlin.hu.wbi.common.filter.Filter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OrFilter<T>
implements Filter<Integer> {
    private List<Filter<Integer>> filters;

    public OrFilter(List<Filter<Integer>> filters) {
        this.filters = new ArrayList<Filter<Integer>>(filters);
    }

    @Override
    public boolean accept(Integer t) {
        for (int i = 0; i < this.filters.size(); ++i) {
            Filter<Integer> filter = this.filters.get(i);
            if (!filter.accept(t)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        List<Integer> list = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9);
        Filter<Integer> even = new Filter<Integer>(){

            @Override
            public boolean accept(Integer t) {
                return t % 2 == 0;
            }
        };
        Filter<Integer> three = new Filter<Integer>(){

            @Override
            public boolean accept(Integer t) {
                return t % 3 == 0;
            }
        };
        OrFilter test = new OrFilter(Arrays.asList(even, three));
        System.out.println(Lists.filter(list, test));
    }
}

