/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.filter;

import de.berlin.hu.wbi.common.collection.Lists;
import de.berlin.hu.wbi.common.filter.Filter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class AndFilter<T>
implements Filter<T> {
    private ArrayList<Filter<T>> filters;

    public AndFilter(Collection<? extends Filter<T>> filters) {
        this.filters = new ArrayList<Filter<T>>(filters);
    }

    @Override
    public boolean accept(T t) {
        for (int i = 0; i < this.filters.size(); ++i) {
            Filter<T> filter = this.filters.get(i);
            if (filter.accept(t)) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        List<Integer> list = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9);
        Filter<Integer> even = new Filter<Integer>(){

            @Override
            public boolean accept(Integer t) {
                return t % 2 == 0;
            }
        };
        Filter<Integer> three = new Filter<Integer>(){

            @Override
            public boolean accept(Integer t) {
                return t % 3 == 0;
            }
        };
        AndFilter test = new AndFilter(Arrays.asList(even, three));
        System.out.println(Lists.filter(list, test));
    }
}

