/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.collection;

import de.berlin.hu.wbi.common.filter.Filter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class Lists {
    public static <T> List<T> filter(Collection<T> input, Filter<? super T> filter) {
        ArrayList<T> out = new ArrayList<T>();
        if (filter != null) {
            for (T t : input) {
                if (!filter.accept(t)) continue;
                out.add(t);
            }
        }
        return out;
    }

    public static void main(String[] args) {
        List<Integer> n = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10);
        Filter<Integer> filter = new Filter<Integer>(){

            @Override
            public boolean accept(Integer t) {
                return t % 2 == 0 && t % 3 == 0;
            }
        };
        n = Lists.filter(n, filter);
        System.out.println(n);
    }

    public static <T> List<T> head(List<T> files, int size) {
        size = Math.min(files.size(), size);
        return files.subList(0, size);
    }
}

