/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class CollectionKit {
    public static <T> List<T> head(Collection<T> input, int size, boolean shuffle) {
        ArrayList<T> output = new ArrayList<T>(size);
        if (shuffle) {
            Collections.shuffle(output, new Random());
        }
        for (T t : input) {
            if (size == 0) break;
            output.add(t);
            --size;
        }
        return output;
    }

    public static <T> ArrayList<T> deduplicate(Collection<T> input) {
        int before = input.size();
        ArrayList<T> output = new ArrayList<T>(new HashSet<T>(input));
        int after = output.size();
        System.out.format("Deduplication: before: %d, after: %d\n", before, after);
        System.gc();
        return output;
    }

    public static <T> Set<T> asSet(T ... a) {
        return new HashSet<T>(Arrays.asList(a));
    }
}

