/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.wrapper.stax;

import de.berlin.hu.ppi.PpiToolkit;
import de.berlin.hu.ppi.wrapper.Protein;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;

public class StaxProtein
implements Protein,
XMLStreamConstants {
    private Map<String, String> ids = new HashMap<String, String>(20);
    private XMLStreamReader parser = null;
    private int internalId = -1;
    private boolean isProtein = false;
    private String experimentalRole = null;
    public static Logger log = Logger.getLogger(StaxProtein.class);

    public StaxProtein(XMLStreamReader parser) throws NumberFormatException, XMLStreamException {
        this.parser = parser;
        this.parse();
    }

    private void parse() throws NumberFormatException, XMLStreamException {
        while (this.parser.hasNext()) {
            switch (this.parser.getEventType()) {
                case 1: {
                    String interactorType;
                    String localName = this.parser.getLocalName();
                    if ("interactor".equals(localName) || "proteinInteractor".equals(localName)) {
                        String attribute = this.parser.getAttributeValue(0);
                        if (attribute == null) break;
                        try {
                            this.internalId = Integer.parseInt(attribute.trim());
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    if ("xref".equals(localName)) {
                        this.parseReferences();
                        break;
                    }
                    if (!"interactorType".equals(localName) || (interactorType = this.parseInteractorType()) == null) break;
                    if ("protein".equalsIgnoreCase(interactorType)) {
                        this.isProtein = true;
                        break;
                    }
                    if (interactorType.equalsIgnoreCase("small molecule") || interactorType.equalsIgnoreCase("dna") || interactorType.equalsIgnoreCase("ds dna") || interactorType.equalsIgnoreCase("mrna") || interactorType.equalsIgnoreCase("rna") || interactorType.equalsIgnoreCase("peptide") || interactorType.equalsIgnoreCase("sirna") || interactorType.equalsIgnoreCase("ss dna") || interactorType.equalsIgnoreCase("nucleic acid") || interactorType.equalsIgnoreCase("trna") || interactorType.equalsIgnoreCase("rrna")) break;
                    log.warn("StaxProtein.parse(): not handled interactor type: " + interactorType);
                    break;
                }
                case 2: {
                    String localName = this.parser.getLocalName();
                    if (!"interactor".equals(localName) && !"proteinInteractor".equals(localName)) break;
                    return;
                }
            }
            this.parser.next();
        }
        log.warn("Kein Protein gefunden!");
    }

    private String parseInteractorType() throws NumberFormatException, XMLStreamException {
        while (this.parser.hasNext()) {
            switch (this.parser.getEventType()) {
                case 1: {
                    String localName = this.parser.getLocalName();
                    if (!"shortLabel".equals(localName) && !"fullName".equals(localName) || !this.parser.hasNext()) break;
                    this.parser.next();
                    if (this.parser.getEventType() != 4) break;
                    return this.parser.getText().toLowerCase();
                }
                case 2: {
                    String localName = this.parser.getLocalName();
                    if (!"names".equals(localName)) break;
                    return null;
                }
            }
            this.parser.next();
        }
        log.warn("Kein InteractionType gefunden!");
        return null;
    }

    private void parseReferences() throws NumberFormatException, XMLStreamException {
        while (this.parser.hasNext()) {
            switch (this.parser.getEventType()) {
                case 1: {
                    String localName = this.parser.getLocalName();
                    if (!"primaryRef".equals(localName) && !"secondaryRef".equals(localName)) break;
                    String name = null;
                    String id = null;
                    for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                        String attributeName = this.parser.getAttributeName(i).toString();
                        if ("db".equals(attributeName)) {
                            name = PpiToolkit.cleanDatabaseName(this.parser.getAttributeValue(i));
                            continue;
                        }
                        if ("id".equals(attributeName)) {
                            id = this.parser.getAttributeValue(i);
                            continue;
                        }
                        if (attributeName.equals("refTypeAc") || attributeName.equals("dbAC") || attributeName.equals("refType") || attributeName.equals("dbAc") || attributeName.equals("secondary") || attributeName.equals("version")) continue;
                        log.warn(this.getClass().getSimpleName() + "StaxProtein.getReferences(): " + "not handled attribute name: " + attributeName + " value: " + this.parser.getAttributeValue(i).toLowerCase());
                    }
                    if (name == null || id == null) break;
                    this.ids.put(name, id);
                    break;
                }
                case 2: {
                    String localName = this.parser.getLocalName();
                    if (!"xref".equals(localName)) break;
                    return;
                }
            }
            this.parser.next();
        }
        log.warn(this.getClass().getSimpleName() + ".parseReferences(): End of parser reached. No referndes found.");
    }

    public boolean isProtein() {
        return this.isProtein;
    }

    @Override
    public Map<String, String> getAllIds() {
        return this.ids;
    }

    @Override
    public String getIdValue(String idName) {
        return this.ids.get(idName);
    }

    public int getInternalId() {
        return this.internalId;
    }

    @Override
    public String getExperimentalRole() {
        return this.experimentalRole;
    }

    public void setExperimentalRole(String experimentalRole) {
        this.experimentalRole = experimentalRole;
    }

    static {
        log.addAppender(new ConsoleAppender(new SimpleLayout()));
        log.setLevel(Level.OFF);
    }
}

