/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.wrapper.stax;

import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.wrapper.Experiment;
import de.berlin.hu.ppi.wrapper.Protein;
import de.berlin.hu.ppi.wrapper.ProteinInteraction;
import de.berlin.hu.ppi.wrapper.stax.StaxExperiment;
import de.berlin.hu.ppi.wrapper.stax.StaxProtein;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;

public class StaxInteraction
implements PpiConstants,
ProteinInteraction,
XMLStreamConstants {
    private int internalId = -1;
    private Map<Integer, Experiment> experimentMap;
    private Map<Integer, StaxProtein> proteinMap;
    private List<Experiment> experiments;
    private List<Protein> interactors = new ArrayList<Protein>(2);
    private String resourceLocator;
    private String interactionType = null;
    private XMLStreamReader parser;
    public static Logger log = Logger.getLogger(StaxInteraction.class);

    public StaxInteraction(XMLStreamReader parser, Map<Integer, StaxProtein> proteinMap, Map<Integer, Experiment> experimentMap, String fileOrigin) throws XMLStreamException {
        this.parser = parser;
        this.experimentMap = experimentMap;
        this.proteinMap = proteinMap;
        this.resourceLocator = fileOrigin;
        this.experiments = new ArrayList<Experiment>(1000);
        this.parse();
    }

    private void parse() throws XMLStreamException {
        while (this.parser.hasNext()) {
            switch (this.parser.getEventType()) {
                case 1: {
                    StaxProtein result;
                    int line = this.parser.getLocation().getLineNumber();
                    String localName = this.parser.getLocalName();
                    if ("interaction".equals(localName)) {
                        for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                            if (!"id".equals(this.parser.getAttributeName(i).toString())) continue;
                            this.internalId = Integer.parseInt(this.parser.getAttributeValue(i));
                        }
                        if (this.internalId != -1) break;
                        log.warn(this.getClass().getSimpleName() + ".parse(): Interaction with missing internal id found (" + this.resourceLocator + ":" + line + ").");
                        break;
                    }
                    if ("experimentRef".equals(localName)) {
                        this.experiments.add(this.parseExperimentByRef());
                        break;
                    }
                    if ("experimentDescription".equals(localName)) {
                        this.experiments.add(this.parseExperiment());
                        break;
                    }
                    if ("interactionType".equals(localName)) {
                        this.interactionType = this.parseInteractionType();
                        break;
                    }
                    if ("inferredInteractionList".equals(localName)) {
                        while (!(!this.parser.hasNext() || this.parser.isEndElement() && "inferredInteractionList".equals(this.parser.getLocalName()))) {
                            this.parser.next();
                        }
                        break;
                    }
                    if ("participant".equals(localName)) {
                        Protein result2 = this.parseParticipant();
                        if (result2 == null) break;
                        this.interactors.add(result2);
                        break;
                    }
                    if (!"proteinInteractor".equals(localName) || (result = new StaxProtein(this.parser)) == null) break;
                    this.interactors.add(result);
                    break;
                }
                case 2: {
                    if (!"interaction".equals(this.parser.getLocalName())) break;
                    if (this.parser.hasNext()) {
                        this.parser.next();
                    }
                    return;
                }
            }
            this.parser.next();
        }
        log.warn(this.getClass().getSimpleName() + ".parse(): End of parser reached (" + this.resourceLocator + ").");
    }

    private Protein parseParticipant() throws XMLStreamException {
        int id = -1;
        int line = this.parser.getLocation().getLineNumber();
        StaxProtein p = null;
        while (this.parser.hasNext()) {
            switch (this.parser.getEventType()) {
                case 1: {
                    if ("interactorRef".equals(this.parser.getLocalName())) {
                        if (!this.parser.hasNext()) break;
                        this.parser.next();
                        if (this.parser.getEventType() != 4) break;
                        id = Integer.parseInt(this.parser.getText());
                        p = this.proteinMap.get(id);
                        break;
                    }
                    if (!"experimentalRoleList".equals(this.parser.getLocalName()) || p == null) break;
                    String role = this.parseExperimentalRoleList();
                    p.setExperimentalRole(role);
                    break;
                }
                case 2: {
                    if (!"participant".equals(this.parser.getLocalName())) break;
                    if (id == -1) {
                        log.warn(this.getClass().getSimpleName() + ".parseParticipant(): Could not parse interactions's internal id  before end of <participant> (" + this.resourceLocator + ":" + line + ").");
                    } else {
                        log.warn(this.getClass().getSimpleName() + ".parseParticipant(): No protein with internal ID: " + id + " found in protein list (" + this.resourceLocator + ":" + line + ").");
                    }
                    if (this.parser.hasNext()) {
                        this.parser.next();
                    }
                    return p;
                }
            }
            this.parser.next();
        }
        log.warn(this.getClass().getSimpleName() + ".parseParticipant(): End of parser. No interactor found (" + this.resourceLocator + ":" + line + ").");
        return null;
    }

    private String parseExperimentalRoleList() throws XMLStreamException {
        String role = null;
        while (this.parser.hasNext()) {
            this.parser.next();
            if (this.parser.getEventType() == 4) continue;
            String localName = this.parser.getLocalName();
            switch (this.parser.getEventType()) {
                case 1: {
                    if (!"fullName".equals(localName) || !this.parser.hasNext()) break;
                    this.parser.next();
                    if (this.parser.getEventType() != 4) break;
                    role = this.parser.getText();
                    role = role.trim().toLowerCase();
                    break;
                }
                case 2: {
                    if (!"experimentalRoleList".equals(localName)) break;
                    if (this.parser.hasNext()) {
                        this.parser.next();
                    }
                    return role;
                }
            }
        }
        return null;
    }

    private String parseInteractionType() throws XMLStreamException {
        int line = this.parser.getLocation().getLineNumber();
        while (this.parser.hasNext()) {
            switch (this.parser.getEventType()) {
                case 1: {
                    String localName = this.parser.getLocalName();
                    if (!"shortLabel".equals(localName) && !"fullName".equals(localName) || !this.parser.hasNext()) break;
                    this.parser.next();
                    if (this.parser.getEventType() != 4) break;
                    return this.parser.getText();
                }
                case 2: {
                    if (!"interactionType".equals(this.parser.getLocalName())) break;
                    log.warn(this.getClass().getSimpleName() + ".parseInteractionType(): No interaction type found (" + this.resourceLocator + ":" + line + ").");
                    return null;
                }
            }
            this.parser.next();
        }
        log.warn(this.getClass().getSimpleName() + ".parseInteractionType(): End of parser.");
        return null;
    }

    private StaxExperiment parseExperiment() throws XMLStreamException {
        while (this.parser.hasNext()) {
            switch (this.parser.getEventType()) {
                case 1: {
                    String localName = this.parser.getLocalName();
                    if (!"experimentDescription".equals(localName)) break;
                    return new StaxExperiment(this.parser);
                }
                case 2: {
                    if (!"experimentList".equals(this.parser.getLocalName())) break;
                    return null;
                }
            }
            this.parser.next();
        }
        log.warn(this.getClass().getSimpleName() + ".parseExperiment(): End of parser.");
        return null;
    }

    private Experiment parseExperimentByRef() throws XMLStreamException {
        while (this.parser.hasNext()) {
            switch (this.parser.getEventType()) {
                case 1: {
                    String localName = this.parser.getLocalName();
                    if (!"experimentRef".equals(localName)) break;
                    if (this.parser.hasNext()) {
                        this.parser.next();
                        if (this.parser.getEventType() == 4) {
                            int id = Integer.parseInt(this.parser.getText());
                            log.debug(this.getClass().getSimpleName() + ".parseExperiment(): Experiment reference with id " + id + " found.");
                            Experiment output = this.experimentMap.get(id);
                            if (output == null) {
                                log.warn(this.getClass().getSimpleName() + ".parseExperiment(): No experiment with id " + id + " found in list of experiments.");
                            }
                            return output;
                        }
                    }
                    log.debug(this.getClass().getSimpleName() + ".parseExperiment(): No internal experiment id found as expected.");
                    return null;
                }
                case 2: {
                    if (!"experimentList".equals(this.parser.getLocalName())) break;
                    return null;
                }
            }
            this.parser.next();
        }
        log.warn(this.getClass().getSimpleName() + ".parseExperiment(): End of parser.");
        return null;
    }

    @Override
    @Deprecated
    public String getDetectionMethod() {
        if (this.experiments.size() == 1) {
            return this.experiments.get(0).getDetectionMethod();
        }
        HashSet<String> methods = new HashSet<String>();
        for (int i = 1; i < this.experiments.size(); ++i) {
            methods.add(this.experiments.get(i).getDetectionMethod());
        }
        Iterator methodIterator = methods.iterator();
        String method = (String)methodIterator.next();
        StringBuilder output = new StringBuilder();
        output.append(method);
        while (methodIterator.hasNext()) {
            output.append(", ");
            output.append((String)methodIterator.next());
        }
        return output.toString();
    }

    @Override
    public String getInteractionType() {
        return this.interactionType;
    }

    @Override
    public Collection<Protein> getInteractors() {
        return this.interactors;
    }

    @Override
    @Deprecated
    public String getPubMedId() {
        if (this.experiments.size() == 1) {
            return this.experiments.get(0).getPubmedId();
        }
        StringBuilder output = new StringBuilder(this.experiments.size() * 20);
        HashSet<String> pubMedIds = new HashSet<String>();
        for (int i = 1; i < this.experiments.size(); ++i) {
            pubMedIds.add(this.experiments.get(i).getPubmedId());
        }
        Iterator pubMedIdIterator = pubMedIds.iterator();
        output.append((String)pubMedIdIterator.next());
        while (pubMedIdIterator.hasNext()) {
            output.append(", ");
            output.append((String)pubMedIdIterator.next());
        }
        return output.toString();
    }

    public int getInternalId() {
        return this.internalId;
    }

    @Override
    public boolean isComplex() {
        return this.interactors.size() > 2;
    }

    @Override
    public boolean isDisease() {
        return this.resourceLocator.toLowerCase().contains("disease");
    }

    @Override
    public boolean isPredicted() {
        return false;
    }

    @Override
    public String getResourceLocator() {
        return this.resourceLocator;
    }

    public boolean isValid() {
        return this.getInteractors().size() > 1;
    }

    @Override
    public Collection<Experiment> getExperiments() {
        return this.experiments;
    }

    static {
        log.addAppender(new ConsoleAppender(new SimpleLayout()));
        log.setLevel(Level.OFF);
    }
}

