/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.wrapper.stax;

import de.berlin.hu.ppi.wrapper.Experiment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;

public class StaxExperiment
implements XMLStreamConstants,
Experiment {
    private int internalId;
    private String detectionMethod;
    private String pubMedId;
    private XMLStreamReader parser;
    private Logger log = Logger.getLogger(StaxExperiment.class);
    private List<Integer> pubmedIds;

    public StaxExperiment(XMLStreamReader parser) throws NumberFormatException, XMLStreamException {
        this.parser = parser;
        this.parse();
    }

    private void parse() throws NumberFormatException, XMLStreamException {
        while (this.parser.hasNext()) {
            switch (this.parser.getEventType()) {
                case 1: {
                    String localName = this.parser.getLocalName();
                    if ("experimentDescription".equals(localName)) {
                        for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                            if (!"id".equals(this.parser.getAttributeLocalName(i))) continue;
                            this.internalId = Integer.parseInt(this.parser.getAttributeValue(0));
                        }
                        break;
                    }
                    if ("bibref".equals(localName)) {
                        this.parsePubMedIds();
                        break;
                    }
                    if (!"interactionDetectionMethod".equals(localName) && !"interactionDetection".equals(localName)) break;
                    this.detectionMethod = this.parseDetectionMethod();
                    break;
                }
                case 2: {
                    String localName = this.parser.getLocalName();
                    if ("experimentList".equals(localName)) {
                        return;
                    }
                    if (!"experimentDescription".equals(localName)) break;
                    return;
                }
            }
            this.parser.next();
        }
        this.log.warn(this.getClass().getSimpleName() + ".parse(): End of parser. No experiment found.");
    }

    /*
     * Unable to fully structure code
     */
    private String parseDetectionMethod() throws XMLStreamException {
        while (this.parser.hasNext()) {
            this.parser.next();
            switch (this.parser.getEventType()) {
                case 1: {
                    localName = this.parser.getLocalName();
                    if (!"shortLabel".equals(localName)) ** GOTO lbl13
                    this.parser.next();
                    if (this.parser.getEventType() == 4) {
                        return this.parser.getText();
                    }
                    ** GOTO lbl18
lbl13:
                    // 1 sources

                    if ("fullName".equals(localName)) {
                        this.parser.next();
                        if (this.parser.getEventType() == 4) {
                            return this.parser.getText();
                        }
                    }
                }
lbl18:
                // 6 sources

                case 2: {
                    localName = this.parser.getLocalName();
                    if (!"interactionDetectionMethod".equals(localName)) break;
                    this.log.warn(this.getClass().getSimpleName() + ".parseInteractionDetectionMethod: Nothing found.");
                    return null;
                }
            }
        }
        this.log.warn(this.getClass().getSimpleName() + ".parseInteractionDetectionMethod(): End of parser. Nothing found.");
        return null;
    }

    private void parsePubMedIds() throws XMLStreamException {
        block6: while (this.parser.hasNext()) {
            this.parser.next();
            switch (this.parser.getEventType()) {
                case 1: {
                    String localName = this.parser.getLocalName();
                    if (!"primaryRef".equals(localName)) break;
                    for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                        String idAttribute;
                        if ("db".equalsIgnoreCase(this.parser.getAttributeLocalName(i))) {
                            if ("pubmed".equalsIgnoreCase(this.parser.getAttributeValue(i))) continue;
                            this.log.warn(this.getClass().getSimpleName() + ".parsePubMedId(): Nothing found.");
                            return;
                        }
                        if (!"id".equalsIgnoreCase(this.parser.getAttributeLocalName(i))) continue;
                        this.pubMedId = idAttribute = this.parser.getAttributeValue(i);
                        if (idAttribute != null && !idAttribute.isEmpty()) {
                            String[] ids = idAttribute.split(";");
                            ArrayList<Integer> idList = new ArrayList<Integer>(1);
                            for (String id : ids) {
                                try {
                                    idList.add(Integer.parseInt(id));
                                }
                                catch (Exception e) {
                                    this.log.error("Could not parse pmid: " + id);
                                }
                            }
                            if (idList.size() > 0) {
                                this.pubmedIds = idList;
                            }
                        }
                        return;
                    }
                    continue block6;
                }
                case 2: {
                    if (!"primaryRef".equals(this.parser.getLocalName())) break;
                    this.log.warn(this.getClass().getSimpleName() + ".parsePubMedId(): Nothing found.");
                }
            }
        }
        this.log.warn(this.getClass().getSimpleName() + ".parsePubMedId(): End of parser. Nothing found.");
    }

    public int getInternalId() {
        return this.internalId;
    }

    @Override
    public String getDetectionMethod() {
        return this.detectionMethod;
    }

    @Override
    public String getPubmedId() {
        return this.pubMedId;
    }

    @Override
    public List<Integer> getPubmedIds() {
        return this.pubmedIds == null ? null : Collections.unmodifiableList(this.pubmedIds);
    }

    static {
        Logger logger = Logger.getLogger(StaxExperiment.class);
        logger.addAppender(new ConsoleAppender(new SimpleLayout()));
        logger.setLevel(Level.OFF);
    }
}

