/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.wrapper;

import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.PpiToolkit;
import de.berlin.hu.ppi.wrapper.MultipleWrapper;
import de.berlin.hu.ppi.wrapper.ProteinInteraction;
import de.berlin.hu.ppi.wrapper.StaxWrapper;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;

public class ZipInteractionIterator
implements Iterator<Iterable<ProteinInteraction>>,
PpiConstants {
    public static Logger log = Logger.getLogger(ZipInteractionIterator.class);
    private ZipFile zipFile;
    private Enumeration<? extends ZipEntry> zipEntries;
    private Iterable<ProteinInteraction> nextInterable = null;

    public static ZipInteractionIterator getZipInteractionIterator(ZipFile zipFile) {
        return new ZipInteractionIterator(zipFile);
    }

    public static ZipInteractionIterator getZipInteractionIterator(File file) throws ZipException, IOException {
        return new ZipInteractionIterator(new ZipFile(file));
    }

    public static ZipInteractionIterator getZipInteractionIterator(String pathToFile) throws ZipException, IOException {
        return ZipInteractionIterator.getZipInteractionIterator(new File(pathToFile));
    }

    public ZipInteractionIterator(ZipFile zipFile) {
        this.zipFile = zipFile;
        this.zipEntries = zipFile.entries();
        while (this.nextInterable == null && this.zipEntries.hasMoreElements()) {
            try {
                ZipEntry currentEntry = this.zipEntries.nextElement();
                this.nextInterable = new StaxWrapper(zipFile.getInputStream(currentEntry), zipFile.getName() + currentEntry.getName());
            }
            catch (IOException e) {
                log.error(ZipInteractionIterator.class.getSimpleName() + "ZipStaxWrapper(): ", e);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextInterable != null;
    }

    @Override
    public Iterable<ProteinInteraction> next() {
        try {
            if (this.hasNext()) {
                Iterable<ProteinInteraction> output = this.nextInterable;
                this.nextInterable = null;
                while (this.nextInterable == null && this.zipEntries.hasMoreElements()) {
                    ZipEntry currentEntry = this.zipEntries.nextElement();
                    this.nextInterable = new StaxWrapper(this.zipFile.getInputStream(currentEntry), this.zipFile.getName() + currentEntry.getName());
                }
                return output;
            }
        }
        catch (IOException e) {
            log.error(e);
        }
        return null;
    }

    @Override
    public void remove() {
        if (this.hasNext()) {
            this.next();
        }
    }

    public static void main(String[] args) {
        try {
            ZipFile cancerZip = new ZipFile(PpiToolkit.getPpiDataPath() + "intact_disease/" + "Cancer.zip");
            ZipInteractionIterator test = new ZipInteractionIterator(cancerZip);
            MultipleWrapper wrapper = new MultipleWrapper(test);
            int count = 0;
            for (ProteinInteraction interaction : wrapper) {
                if (Math.random() < 1.0) {
                    PpiToolkit.printInteractionInfo(interaction);
                }
                ++count;
            }
            log.info("Interaction count: " + count);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

