/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.wrapper;

import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.wrapper.Experiment;
import de.berlin.hu.ppi.wrapper.ProteinInteraction;
import de.berlin.hu.ppi.wrapper.stax.StaxExperiment;
import de.berlin.hu.ppi.wrapper.stax.StaxInteraction;
import de.berlin.hu.ppi.wrapper.stax.StaxProtein;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;

public class StaxWrapper
implements Iterable<ProteinInteraction>,
Iterator<ProteinInteraction>,
PpiConstants,
XMLStreamConstants {
    private Map<Integer, Experiment> experimentMap = new HashMap<Integer, Experiment>(10000);
    private StaxInteraction nextProteinInteraction = null;
    private String origin;
    private XMLStreamReader parser;
    private Map<Integer, StaxProtein> proteinMap = new HashMap<Integer, StaxProtein>(10000);
    private Logger log = Logger.getLogger(StaxWrapper.class);

    public StaxWrapper(InputStream inputStream, String resourceLocator) {
        if (inputStream == null) {
            throw new NullPointerException("InputStream must not be null.");
        }
        this.parser = StaxWrapper.getParser(inputStream);
        if (resourceLocator == null || resourceLocator.isEmpty()) {
            this.log.warn(this.getClass().getSimpleName() + ": Resource Locator should not be null or empy.");
        }
        this.origin = resourceLocator;
    }

    public StaxWrapper(File file) {
        this.parser = StaxWrapper.getParser(file);
        this.origin = file.getAbsolutePath();
    }

    public static XMLStreamReader getParser(InputStream inputStream) {
        try {
            return XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
        }
        catch (XMLStreamException e) {
            Logger.getRootLogger().error("", e);
            return null;
        }
    }

    public static XMLStreamReader getParser(File file) {
        try {
            return StaxWrapper.getParser(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            Logger.getRootLogger().error("", e);
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        boolean output = this.nextProteinInteraction != null;
        return output;
    }

    private void initialize() throws XMLStreamException {
        while (this.parser.hasNext()) {
            switch (this.parser.getEventType()) {
                case 1: {
                    String localName = this.parser.getLocalName();
                    if ("experimentList".equals(localName)) {
                        this.parseExperimentList();
                        break;
                    }
                    if ("interactorList".equals(localName)) {
                        this.parseInteractorList();
                        break;
                    }
                    if (!"interaction".equals(localName)) break;
                    this.nextProteinInteraction = new StaxInteraction(this.parser, this.proteinMap, this.experimentMap, this.origin);
                    return;
                }
            }
            this.parser.next();
        }
        this.log.warn(this.getClass().getSimpleName() + ".initialize: End of Parser. No interactions found in File " + this.origin);
    }

    @Override
    public Iterator<ProteinInteraction> iterator() {
        try {
            this.initialize();
            return this;
        }
        catch (XMLStreamException e) {
            this.log.error("Fehler beim Initialisieren.", e);
            return null;
        }
    }

    @Override
    public ProteinInteraction next() {
        if (this.hasNext()) {
            try {
                StaxInteraction output = this.nextProteinInteraction;
                this.nextProteinInteraction = null;
                while (this.parser.hasNext() && (this.nextProteinInteraction == null || !this.nextProteinInteraction.isValid())) {
                    if (this.parser.getEventType() == 1 && "interaction".equals(this.parser.getLocalName())) {
                        this.nextProteinInteraction = new StaxInteraction(this.parser, this.proteinMap, this.experimentMap, this.origin);
                        continue;
                    }
                    this.parser.next();
                }
                if (!this.parser.hasNext()) {
                    this.parser.close();
                }
                return output;
            }
            catch (XMLStreamException e) {
                this.log.error(null, e);
            }
        } else {
            this.log.warn(this.getClass().getSimpleName() + ".next(): There is no next protein interaction. 'null' returned.");
        }
        return null;
    }

    private void parseExperimentList() throws XMLStreamException {
        while (this.parser.hasNext()) {
            switch (this.parser.getEventType()) {
                case 1: {
                    if (!"experimentDescription".equals(this.parser.getLocalName())) break;
                    StaxExperiment currentExperiment = new StaxExperiment(this.parser);
                    this.experimentMap.put(currentExperiment.getInternalId(), currentExperiment);
                    break;
                }
                case 2: {
                    if (!"experimentList".equals(this.parser.getLocalName())) break;
                    if (this.parser.hasNext()) {
                        this.parser.next();
                    }
                    if (this.experimentMap.size() == 0) {
                        this.log.warn(this.getClass().getSimpleName() + ".parseExperiments(): No experiments found in File " + this.origin);
                    }
                    return;
                }
            }
            this.parser.next();
        }
        this.log.warn(this.getClass().getSimpleName() + ": End of parser reached and no Experiments found!");
        this.parser.close();
    }

    public void parseInteractorList() throws NumberFormatException, XMLStreamException {
        while (this.parser.hasNext()) {
            switch (this.parser.getEventType()) {
                case 1: {
                    StaxProtein protein;
                    if (!"interactor".equals(this.parser.getLocalName()) || !(protein = new StaxProtein(this.parser)).isProtein()) break;
                    this.proteinMap.put(protein.getInternalId(), protein);
                    break;
                }
                case 2: {
                    if (!"interactorList".equals(this.parser.getLocalName())) break;
                    if (this.parser.hasNext()) {
                        this.parser.next();
                    }
                    if (this.experimentMap.size() == 0) {
                        this.log.warn(this.getClass().getSimpleName() + ".parseProteins(): No proteins found in File " + this.origin);
                    }
                    return;
                }
            }
            this.parser.next();
        }
        this.log.warn(this.getClass().getSimpleName() + ".parseProteins(): End of parser. No proteins found in File " + this.origin);
        this.parser.close();
    }

    @Override
    public void remove() {
        if (this.hasNext()) {
            this.next();
        }
    }
}

