/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update.plugin;

import de.berlin.hu.ppi.update.AbstractUpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePluginException;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import org.apache.log4j.Logger;

public final class UniprotMappingUpdatePlugin
extends AbstractUpdatePlugin {
    private static final String TABLE_LOOKUP_MAPPING = "lookup_mapping";
    private static final int TASK_DOWNLOADING = 0;
    private static final int TASK_EXTRACTING = 1;
    private static final int TASK_LOADING_DATASETS = 2;
    private static final int TASK_ENABLING_KEYS = 3;
    private static final String URL_ID_MAPPING = "ftp://ftp.uniprot.org/pub/databases/uniprot/current_release/knowledgebase/idmapping/idmapping.dat.gz";
    private static UpdatePlugin instance;
    private static final String KEY_IMPORT_DURATION = "importDuration";
    private static final String KEY_ENABLING_KEYS_DURATION = "enablingKeysDuration";
    private Statement currentStatement;

    private UniprotMappingUpdatePlugin() throws Exception {
        this.taskCount = 4;
        this.taskDescriptions = new String[]{"Downloading file...", "Extracting file...", "Loading datasets...", "Enable keys..."};
        this.pluginName = "Uniprot Id Mappings";
        this.description = "This plugin updates Uniprot reference data used for ID-mapping.";
        this.log = Logger.getLogger(UniprotMappingUpdatePlugin.class);
        this.tableNames = new String[]{TABLE_LOOKUP_MAPPING};
        this.checkForUpdates();
    }

    public static UpdatePlugin getInstance() throws Exception {
        if (instance == null) {
            instance = new UniprotMappingUpdatePlugin();
        }
        return instance;
    }

    @Override
    public void runUpdate() throws SQLException, IOException {
        this.startTask(0);
        File mappingFile = this.download(URL_ID_MAPPING);
        if (this.isInterrupted) {
            return;
        }
        this.startTask(1);
        String extractedFile = mappingFile.getParent() + File.separatorChar + UniprotMappingUpdatePlugin.getTempName(TABLE_LOOKUP_MAPPING);
        this.log.info("Extraction to " + extractedFile);
        File destination = new File(extractedFile);
        this.extractGZip(mappingFile, destination);
        this.startTask(2);
        this.loadingDatasetsNew(extractedFile);
        this.startTask(3);
        Connection connection = this.openDatabaseConnection();
        this.enableKeys(connection);
    }

    private void enableKeys(Connection connection) throws SQLException {
        Statement enableKeysStatement;
        long duration;
        if (this.isInterrupted) {
            return;
        }
        long startTime = System.currentTimeMillis();
        try {
            duration = Long.parseLong(this.getProperty(KEY_ENABLING_KEYS_DURATION));
        }
        catch (Exception e) {
            this.log.info("No duration information for creating index found.");
            duration = 1200000L;
        }
        this.setTaskDescription("Creating Index");
        this.deriveTaskProgressFromDuration(duration);
        this.currentStatement = enableKeysStatement = connection.createStatement();
        try {
            enableKeysStatement.executeUpdate(String.format("alter table %s enable keys", UniprotMappingUpdatePlugin.getTempName(TABLE_LOOKUP_MAPPING)));
        }
        catch (Exception e) {
            // empty catch block
        }
        enableKeysStatement.close();
        if (this.isInterrupted) {
            return;
        }
        this.setProperty(KEY_ENABLING_KEYS_DURATION, String.valueOf(System.currentTimeMillis() - startTime));
    }

    @Override
    public UpdatePlugin.UpdateType getType() {
        return UpdatePlugin.UpdateType.LOOKUP_TABLES;
    }

    @Override
    protected int getCurrentUpdateHash() throws Exception {
        return this.computeHashCodeFromOnlineFiles(Arrays.asList(URL_ID_MAPPING));
    }

    private void loadingDatasetsNew(String extractedFile) throws SQLException {
        Statement loadDataStatement;
        long oldDuration;
        this.taskDescription = "hui";
        try {
            oldDuration = Long.parseLong(this.getProperty(KEY_IMPORT_DURATION));
        }
        catch (Exception e) {
            this.log.info("No old import duration found.");
            oldDuration = 1500000L;
        }
        this.setTaskDescription("Loading datasets");
        this.deriveTaskProgressFromDuration(oldDuration);
        Connection con = this.openDatabaseConnection();
        this.createTempTables();
        con.createStatement().executeUpdate(String.format("alter table %s disable keys", UniprotMappingUpdatePlugin.getTempName(TABLE_LOOKUP_MAPPING)));
        if (this.isInterrupted) {
            return;
        }
        this.currentStatement = loadDataStatement = this.connection.createStatement();
        String sql = "LOAD DATA LOCAL INFILE '%s' INTO TABLE %s IGNORE 0 LINES";
        try {
            loadDataStatement.executeUpdate(String.format(sql, extractedFile, UniprotMappingUpdatePlugin.getTempName(TABLE_LOOKUP_MAPPING)));
        }
        catch (Exception e) {
            // empty catch block
        }
        loadDataStatement.close();
        if (this.isInterrupted) {
            return;
        }
        this.setProperty(KEY_IMPORT_DURATION, Long.toString(System.currentTimeMillis() - this.taskStartTime));
    }

    @Override
    public void cancel() throws UpdatePluginException {
        super.cancel();
        new Thread(){

            @Override
            public void run() {
                try {
                    if (UniprotMappingUpdatePlugin.this.currentStatement != null && !UniprotMappingUpdatePlugin.this.currentStatement.isClosed()) {
                        UniprotMappingUpdatePlugin.this.log.info("Cancelling running statement...");
                        UniprotMappingUpdatePlugin.this.currentStatement.close();
                        UniprotMappingUpdatePlugin.this.currentStatement = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }
}

