/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update.plugin;

import de.berlin.hu.ppi.net.StreamSource;
import de.berlin.hu.ppi.net.StreamSourceFactory;
import de.berlin.hu.ppi.update.AbstractUpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePluginException;
import java.io.File;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.log4j.Logger;

public final class UniprotDemergedUpdatePlugin
extends AbstractUpdatePlugin {
    private static final int LOADING_DATASETS = 0;
    private int countedDatasets = 0;
    private int insertedDatasets = 0;
    private static UpdatePlugin instance;
    private static final String LOOKUP_UNIPROT_DEMERGED = "lookup_uniprot_demerged";
    private static final String SQL_INSERT_UNIPROT_DEMERGED = "INSERT INTO lookup_uniprot_demerged VALUES (?,?)";
    public static final String url = "http://www.uniprot.org/uniprot/?query=active:no&compress=yes&format=tab&columns=id,entry%20name,reviewed,protein%20names,genes,organism,length";

    private UniprotDemergedUpdatePlugin() throws Exception {
        this.taskCount = 1;
        this.taskDescriptions = new String[]{"Loading new data into database"};
        this.pluginName = "Uniprot Demerged";
        this.description = "This plugin updates Uniprot reference data used for checking 'demerged' uniprot entries.";
        this.log = Logger.getLogger(UniprotDemergedUpdatePlugin.class);
        this.checkForUpdates();
    }

    public static UpdatePlugin getInstance() throws Exception {
        if (instance == null) {
            instance = new UniprotDemergedUpdatePlugin();
        }
        return instance;
    }

    public boolean isUpdateAvailable(File targetfile) {
        return !targetfile.exists();
    }

    @Override
    public void reset() throws UpdatePluginException {
        super.reset();
        this.countedDatasets = 0;
        this.insertedDatasets = 0;
    }

    @Override
    public void runUpdate() throws SQLException, IOException {
        if (!this.isInterrupted) {
            this.startTask(0);
            String value = this.getProperty("dataCount");
            int valueInt = 1721624;
            try {
                valueInt = Integer.parseInt(value);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.setCounterFinish(valueInt);
            StreamSource source = StreamSourceFactory.getStreamSourceByUrl(url);
            this.openGzipReader(source.getStream());
            this.openDatabaseConnection();
            this.connection.setAutoCommit(false);
            this.createTempTables();
            PreparedStatement insertDemerged = this.connection.prepareStatement(SQL_INSERT_UNIPROT_DEMERGED);
            String line = this.reader.readLine();
            while (line != null && !this.isInterrupted) {
                ++this.countedDatasets;
                if (line.contains("Demerged")) {
                    String[] newIds;
                    String[] oldAndNew = line.split("\\s+.+Demerged\\s+into\\s+");
                    String oldId = oldAndNew[0];
                    for (String newId : newIds = oldAndNew[1].split("(,| and|\\.)\\s+")) {
                        insertDemerged.setString(1, oldId);
                        insertDemerged.setString(2, newId);
                        if (this.insertedDatasets % this.getBatchSize() == 0) {
                            insertDemerged.executeBatch();
                        }
                        insertDemerged.addBatch();
                    }
                    ++this.insertedDatasets;
                }
                line = this.reader.readLine();
                this.incrementCounter();
            }
            insertDemerged.executeBatch();
            if (!this.isInterrupted) {
                this.setProperty("dataCount", Integer.toString(this.countedDatasets));
            }
        }
    }

    @Override
    public UpdatePlugin.UpdateType getType() {
        return UpdatePlugin.UpdateType.LOOKUP_TABLES;
    }

    @Override
    protected int getCurrentUpdateHash() throws Exception {
        return this.computeHashCodeFromOnlineFiles(Arrays.asList(url));
    }
}

