/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update.plugin;

import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.db.DbService;
import de.berlin.hu.ppi.mediator.LoaderException;
import de.berlin.hu.ppi.mediator.ProteinLoader;
import de.berlin.hu.ppi.mediator.dbx.DBProtein;
import de.berlin.hu.ppi.parser.object.Edge;
import de.berlin.hu.ppi.parser.object.ExternalRef;
import de.berlin.hu.ppi.parser.object.Graph;
import de.berlin.hu.ppi.parser.object.InterConnection;
import de.berlin.hu.ppi.parser.object.Vertex;
import de.berlin.hu.ppi.parser.object.VertexPair;
import de.berlin.hu.ppi.tool.StringTransformationMethods;
import de.berlin.hu.ppi.tool.UniprotAccessionNumbersPlugin;
import de.berlin.hu.ppi.tool.UniprotTaxIdPlugin;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class StorePathwaysInDB
implements PpiConstants {
    public static final int DB_MAX_STRING_LENGTH = 255;
    private static StorePathwaysInDB instance = null;
    private DbService service = DbService.getCurrentService();
    private Connection connection = null;
    private UniprotTaxIdPlugin uniprotTaxId = (UniprotTaxIdPlugin)UniprotTaxIdPlugin.getInstance();
    private ProteinLoader proteinLoader = new ProteinLoader(this.service.getNewConnection());
    private int runningPathwayPluginsCounter;
    private PreparedStatement insertPathway;
    private PreparedStatement insertDbSource;
    private PreparedStatement insertMolecule;
    private PreparedStatement insertMoleculePathwayRelation;
    private PreparedStatement insertSynonym;
    private PreparedStatement insertComplex;
    private PreparedStatement insertEdge;
    private PreparedStatement insertReference;
    private PreparedStatement insertInteraction;
    private PreparedStatement insertInterconnection;
    private PreparedStatement selectDbSource;
    private PreparedStatement insertSequence;
    private PreparedStatement insertChromosomalLocation;
    private PreparedStatement selectProtein;
    private PreparedStatement updateMolecule;
    private int uniqueInteractionId;

    private StorePathwaysInDB() throws Exception {
        ((UniprotAccessionNumbersPlugin)UniprotAccessionNumbersPlugin.getInstance()).loadDataFromDatabase(this.service.getNewConnection());
        this.runningPathwayPluginsCounter = 0;
    }

    public static synchronized StorePathwaysInDB getInstance() throws Exception {
        if (instance == null) {
            instance = new StorePathwaysInDB();
        }
        return instance;
    }

    public synchronized void addSourceToDB(PpiConstants.DB_ID dbId) throws Exception {
        this.selectDbSource.setInt(1, dbId.ordinal());
        ResultSet result = this.selectDbSource.executeQuery();
        if (!result.next()) {
            this.insertDbSource.setInt(1, dbId.ordinal());
            this.insertDbSource.setString(2, dbId.toString().toLowerCase());
            this.insertDbSource.executeUpdate();
        }
    }

    public synchronized void establishConnection() throws Exception {
        ++this.runningPathwayPluginsCounter;
        if (this.connection == null || this.connection.isClosed()) {
            this.connection = this.service.getStaticConnection();
            this.setUpPreparedStatements();
        }
    }

    private void setUpPreparedStatements() throws SQLException {
        this.insertPathway = this.connection.prepareStatement("INSERT INTO pathway (id, db_source_id, name, interconnection_id, short_name, taxon_id, last_update, ppi) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        this.insertMolecule = this.connection.prepareStatement("INSERT INTO molecule (type_id, name, short_name, primary_uniprot_id, tax_id, cellular_location) VALUES (?, ?, ?, ?, ?, ?)", new String[]{"id"});
        this.insertSequence = this.connection.prepareStatement("INSERT INTO sequence (molecule_id, sequence) VALUES (?,?)");
        this.insertChromosomalLocation = this.connection.prepareStatement("INSERT IGNORE INTO chromosomal_location (molecule_id, location) VALUES (?,?)");
        this.insertSynonym = this.connection.prepareStatement("INSERT IGNORE INTO synonym (molecule_id, synonym) VALUES (?, ?)");
        this.insertComplex = this.connection.prepareStatement("INSERT IGNORE INTO complex (molecule_id, complex_part_id) VALUES (?, ?)");
        this.insertEdge = this.connection.prepareStatement("INSERT IGNORE INTO edge (interaction_id, pathway_id, db_source_id, molecule_id1, molecule_id2) VALUES (?, ?, ?, ?, ?)");
        this.insertReference = this.connection.prepareStatement("INSERT IGNORE INTO reference (molecule_id, db, id) VALUES (?, ?, ?)");
        this.insertInteraction = this.connection.prepareStatement("INSERT IGNORE INTO interaction (id, name, short_name, type, direction, pathway_id, db_source_id) VALUES (?, ?, ?, ?, ?, ?, ?)");
        this.insertInterconnection = this.connection.prepareStatement("INSERT IGNORE INTO interconnection (pathway_id, db_source_id, connected_pathway_name, intermediate_id) VALUES (?, ?, ?, ?)");
        this.insertDbSource = this.connection.prepareStatement("INSERT INTO db_source (db_source_id, db_source_name) VALUES (?, ?)");
        this.insertMoleculePathwayRelation = this.connection.prepareStatement("INSERT IGNORE INTO molecule_pathway_relation (molecule_id, pathway_id, db_source_id) VALUES (?, ?, ?)");
        this.selectDbSource = this.connection.prepareStatement("SELECT * FROM db_source WHERE db_source_id = ?");
        this.selectProtein = this.connection.prepareStatement("SELECT id FROM molecule WHERE primary_uniprot_id = ?");
        this.updateMolecule = this.connection.prepareStatement("UPDATE molecule SET cellular_location = ? WHERE id = ?");
    }

    public synchronized void closeConnection() throws SQLException {
        --this.runningPathwayPluginsCounter;
        if (this.runningPathwayPluginsCounter == 0) {
            this.connection.close();
        }
    }

    public synchronized void loadPathwayIntoDb(Graph pathway, int pathwayId, java.util.Date recent, PpiConstants.DB_ID dbId) throws SQLException, LoaderException {
        this.uniqueInteractionId = 0;
        this.insertPathway(pathwayId, pathway.getName(), pathway.getId(), pathway.getShortName(), pathway.getOrganism(), dbId, recent, pathway.isPPI());
        Iterator<String> vertices = pathway.getVerticesIterator();
        ArrayList<Vertex> verticesInOrder = new ArrayList<Vertex>();
        while (vertices.hasNext()) {
            DBProtein[] proteins;
            Vertex vertex = pathway.getVertex(vertices.next());
            verticesInOrder.add(vertex);
            if (vertex.isRepresentativeMolecule()) {
                vertex.setType(PpiConstants.MOLECULE_TYPE.REPRESENTATIVEMOLECULE.name());
            } else {
                if (vertex.getType() == PpiConstants.MOLECULE_TYPE.PHYSICALENTITY || vertex.getType() == PpiConstants.MOLECULE_TYPE.GENE) {
                    vertex.setType(PpiConstants.MOLECULE_TYPE.PROTEIN.name());
                }
                if (vertex.getIdValue("uniprot") != null) {
                    vertex.setType(PpiConstants.MOLECULE_TYPE.PROTEIN.name());
                }
            }
            int moleculeId = -1;
            if (vertex.getType() == PpiConstants.MOLECULE_TYPE.PROTEIN && (proteins = this.proteinLoader.load(vertex)) != null && proteins.length > 0) {
                if (proteins.length > 1) {
                    System.err.println("HELP");
                    for (int i = 0; i < proteins.length; ++i) {
                        System.out.println("\tProtein: " + i);
                        for (String key : proteins[i].getProperties().stringPropertyNames()) {
                            System.out.println("\t\t" + key + ":::" + proteins[i].getProperty(key));
                        }
                    }
                }
                vertex.setAlreadyKnown(proteins[0].isPersistent());
                moleculeId = proteins[0].insert();
                if (vertex.getCellularLocation() != null) {
                    this.updateMolecule.setString(1, vertex.getCellularLocation());
                    this.updateMolecule.setInt(2, moleculeId);
                }
            }
            if (moleculeId == -1) {
                if (vertex.getType() == PpiConstants.MOLECULE_TYPE.PROTEIN && vertex.getIdValue("uniprot") != null) {
                    this.selectProtein.setString(1, vertex.getIdValue("uniprot"));
                    ResultSet existingProtein = this.selectProtein.executeQuery();
                    if (existingProtein.next()) {
                        vertex.setGeneratedId(existingProtein.getInt(1));
                        vertex.setAlreadyKnown(true);
                    }
                }
                if (vertex.isAlreadyKnown()) continue;
                String organism = vertex.getOrganism();
                if (organism == null) {
                    organism = pathway.getOrganism();
                }
                if (vertex.getType() == PpiConstants.MOLECULE_TYPE.PROTEIN) {
                    this.insertMolecule(vertex.getName(), vertex.getShortName(), organism, vertex.getIdValue("uniprot"), vertex.getCellularLocation(), vertex.getType());
                } else {
                    this.insertMolecule(vertex.getName(), vertex.getShortName(), organism, null, vertex.getCellularLocation(), vertex.getType());
                }
                ResultSet autoGeneratedKeys = this.insertMolecule.getGeneratedKeys();
                autoGeneratedKeys.next();
                vertex.setGeneratedId(autoGeneratedKeys.getInt(1));
                this.insertSequenceAndChromsomalLocation(vertex.getGeneratedId(), vertex.getSequence(), vertex.getChromosomalPosition());
                continue;
            }
            vertex.setGeneratedId(moleculeId);
        }
        vertices = pathway.getVerticesIterator();
        for (Vertex vertex : verticesInOrder) {
            this.insertMoleculePathwayRelation(vertex.getGeneratedId(), pathwayId, dbId);
            if (vertex.isAlreadyKnown()) continue;
            for (int i = 0; i < vertex.getSynonymsSize(); ++i) {
                this.insertSynonym(vertex.getGeneratedId(), vertex.getSynonym(i));
            }
            Iterator<ExternalRef> refs = vertex.getExternalRefs();
            while (refs.hasNext()) {
                ExternalRef xref = refs.next();
                if (xref.getDb().equalsIgnoreCase("RN")) continue;
                if (xref.getId().length() > 255) {
                    System.err.println("Too long id: " + xref.getDb() + ":" + xref.getId());
                }
                if (StringTransformationMethods.isEmptyOrBlank(xref.getDb()) || StringTransformationMethods.isEmptyOrBlank(xref.getId())) continue;
                this.insertExternalRef(vertex.getGeneratedId(), xref.getDb(), xref.getId());
            }
            if (!vertex.isComplex()) continue;
            for (int i = 0; i < vertex.getComplexPartsSize(); ++i) {
                this.insertComplex(vertex.getGeneratedId(), pathway.getVertex(vertex.getComplexPart(i)).getGeneratedId());
            }
        }
        Iterator<String> edges = pathway.getEdgesIterator();
        while (edges.hasNext()) {
            Edge edge = pathway.getEdge(edges.next());
            edge.setGeneratedId(this.uniqueInteractionId++);
            this.insertInteraction(edge.getGeneratedId(), edge.getName(), edge.getShortName(), edge.getType(), edge.getDirection(), pathwayId, dbId);
            for (int i = 0; i < edge.getVertexPairsSize(); ++i) {
                VertexPair pair = edge.getVertexPair(i);
                Vertex vertex1 = pathway.getVertex(pair.getStart());
                Vertex vertex2 = pathway.getVertex(pair.getEnd());
                this.insertEdge(edge.getGeneratedId(), pathwayId, dbId, vertex1.getGeneratedId(), vertex2.getGeneratedId());
            }
        }
        Iterator<InterConnection> interConnections = pathway.getInterConnectionsIterator();
        while (interConnections.hasNext()) {
            InterConnection iConn = interConnections.next();
            Integer intermediateId = iConn.getIntermediate() == null ? null : Integer.valueOf(pathway.getVertex(iConn.getIntermediate()).getGeneratedId());
            this.insertInterconnection(pathwayId, dbId, iConn.getPathway(), intermediateId);
        }
    }

    private void insertPathway(int id, String name, String interConnectionId, String shortName, String organism, PpiConstants.DB_ID dbId, java.util.Date lastUpdate, boolean isPPI) throws SQLException {
        this.insertPathway.setInt(1, id);
        this.insertPathway.setInt(2, dbId.ordinal());
        this.insertPathway.setString(3, name);
        this.insertPathway.setString(4, interConnectionId);
        this.insertPathway.setString(5, shortName);
        Integer tmp = this.uniprotTaxId.getTaxonIdForOrganism(organism);
        if (tmp == null) {
            this.insertPathway.setNull(6, 4);
        } else {
            this.insertPathway.setInt(6, tmp);
        }
        if (lastUpdate != null) {
            this.insertPathway.setDate(7, new Date(lastUpdate.getTime()));
        } else {
            this.insertPathway.setNull(7, 91);
        }
        if (isPPI) {
            this.insertPathway.setInt(8, 1);
        } else {
            this.insertPathway.setInt(8, 0);
        }
        this.insertPathway.executeUpdate();
    }

    private void insertMolecule(String name, String shortName, String organism, String primaryUniprotId, String cellularLocation, PpiConstants.MOLECULE_TYPE type) throws SQLException {
        this.insertMolecule.setInt(1, type.ordinal());
        this.insertMolecule.setString(2, name);
        this.insertMolecule.setString(3, shortName);
        if (primaryUniprotId == null) {
            this.insertMolecule.setNull(4, 12);
        } else {
            this.insertMolecule.setString(4, primaryUniprotId);
        }
        Integer tmp = this.uniprotTaxId.getTaxonIdForOrganism(organism);
        if (tmp == null) {
            this.insertMolecule.setNull(5, 4);
        } else {
            this.insertMolecule.setInt(5, tmp);
        }
        this.insertMolecule.setString(6, cellularLocation);
        this.insertMolecule.executeUpdate();
    }

    private void insertSequenceAndChromsomalLocation(int vertexId, String sequence, String chromosomalLocation) throws SQLException {
        if (sequence != null) {
            for (String seq : sequence.split(" ")) {
                this.insertSequence.setInt(1, vertexId);
                this.insertSequence.setString(2, seq);
                this.insertSequence.executeUpdate();
            }
        }
        if (chromosomalLocation != null) {
            for (String chrom : chromosomalLocation.split(" ")) {
                this.insertChromosomalLocation.setInt(1, vertexId);
                this.insertChromosomalLocation.setString(2, chrom);
                this.insertChromosomalLocation.executeUpdate();
            }
        }
    }

    private void insertSynonym(int vertexId, String synonym) throws SQLException {
        this.insertSynonym.setInt(1, vertexId);
        this.insertSynonym.setString(2, synonym);
        this.insertSynonym.executeUpdate();
    }

    private void insertComplex(int vertexId, int complexPartId) throws SQLException {
        this.insertComplex.setInt(1, vertexId);
        this.insertComplex.setInt(2, complexPartId);
        this.insertComplex.executeUpdate();
    }

    private void insertEdge(int interactionId, int pathwayId, PpiConstants.DB_ID dbId, int vertex1, int vertex2) throws SQLException {
        this.insertEdge.setInt(1, interactionId);
        this.insertEdge.setInt(2, pathwayId);
        this.insertEdge.setInt(3, dbId.ordinal());
        this.insertEdge.setInt(4, vertex1);
        this.insertEdge.setInt(5, vertex2);
        this.insertEdge.executeUpdate();
    }

    private void insertExternalRef(int vertexId, String db, String id) throws SQLException {
        this.insertReference.setInt(1, vertexId);
        this.insertReference.setString(2, db);
        this.insertReference.setString(3, id);
        this.insertReference.executeUpdate();
    }

    private void insertInteraction(int id, String name, String shortName, String type, int direction, int pathwayId, PpiConstants.DB_ID dbId) throws SQLException {
        this.insertInteraction.setInt(1, id);
        this.insertInteraction.setString(2, name);
        this.insertInteraction.setString(3, shortName);
        this.insertInteraction.setString(4, type);
        this.insertInteraction.setInt(5, direction);
        this.insertInteraction.setInt(6, pathwayId);
        this.insertInteraction.setInt(7, dbId.ordinal());
        this.insertInteraction.executeUpdate();
    }

    private void insertInterconnection(int pathwayId, PpiConstants.DB_ID dbId, String connectedPathwayName, Integer intermediateId) throws SQLException {
        this.insertInterconnection.setInt(1, pathwayId);
        this.insertInterconnection.setInt(2, dbId.ordinal());
        this.insertInterconnection.setString(3, connectedPathwayName);
        if (intermediateId == null) {
            this.insertInterconnection.setNull(4, 4);
        } else {
            this.insertInterconnection.setInt(4, intermediateId);
        }
        this.insertInterconnection.executeUpdate();
    }

    private void insertMoleculePathwayRelation(int moleculeId, int pathwayId, PpiConstants.DB_ID dbId) throws SQLException {
        this.insertMoleculePathwayRelation.setInt(1, moleculeId);
        this.insertMoleculePathwayRelation.setInt(2, pathwayId);
        this.insertMoleculePathwayRelation.setInt(3, dbId.ordinal());
        this.insertMoleculePathwayRelation.executeUpdate();
    }

    public synchronized void storeNewTaxonIds() throws Exception {
        this.uniprotTaxId.loadNewTaxonIdsForOrganismsIntoDb();
    }

    public synchronized void deleteDataFromTables(PpiConstants.DB_ID dbSource) throws SQLException {
        Statement stmt = this.connection.createStatement();
        for (String table : Arrays.asList("pathway", "interconnection", "interaction", "edge")) {
            StringBuilder sqlCommand = new StringBuilder();
            sqlCommand.append("DELETE FROM ");
            sqlCommand.append(table);
            if (dbSource != null) {
                sqlCommand.append(" WHERE db_source_id = ");
                sqlCommand.append(dbSource.ordinal());
            }
            stmt.executeUpdate(sqlCommand.toString());
        }
        String ids = null;
        if (dbSource != null) {
            ResultSet rs = stmt.executeQuery("select molecule_id from (select molecule_id, db_source_id, count(*) as count from (select * from molecule_pathway_relation group by molecule_id, db_source_id) as tmp group by molecule_id) as tmp2 where tmp2.count = 1 and db_source_id = " + dbSource.ordinal());
            StringBuilder sb = new StringBuilder();
            while (rs.next()) {
                sb.append(rs.getInt(1));
                sb.append(", ");
            }
            if (sb.length() != 0) {
                ids = sb.substring(0, sb.length() - 2);
            }
        }
        if (ids != null && dbSource != null || dbSource == null) {
            for (String table : Arrays.asList("molecule", "chromosomal_location", "sequence", "complex", "reference", "synonym", "interpro_rel", "go_rel", "go_rel_evidence", "reactome_rel")) {
                StringBuilder sqlCommand = new StringBuilder();
                sqlCommand.append("DELETE ");
                sqlCommand.append("FROM ");
                sqlCommand.append(table);
                if (dbSource != null) {
                    sqlCommand.append(" WHERE ");
                    if (table.equals("molecule")) {
                        sqlCommand.append("id ");
                    } else if (table.equals("interpro_rel") || table.equals("go_rel") || table.equals("go_rel_evidence") || table.equals("reactome_rel")) {
                        sqlCommand.append("protein_id ");
                    } else {
                        sqlCommand.append("molecule_id ");
                    }
                    sqlCommand.append("IN (");
                    sqlCommand.append(ids);
                    sqlCommand.append(" )");
                }
                stmt.executeUpdate(sqlCommand.toString());
            }
        }
        StringBuilder sqlCommand = new StringBuilder();
        sqlCommand.append("DELETE FROM ");
        sqlCommand.append("molecule_pathway_relation");
        if (dbSource != null) {
            sqlCommand.append(" WHERE db_source_id = ");
            sqlCommand.append(dbSource.ordinal());
        }
        stmt.executeUpdate(sqlCommand.toString());
        stmt.close();
    }
}

