/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update.plugin;

import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.parser.FileParsingException;
import de.berlin.hu.ppi.parser.PathwayAbsentParser;
import de.berlin.hu.ppi.parser.PathwayParser;
import de.berlin.hu.ppi.tool.FileTool;
import de.berlin.hu.ppi.update.AbstractPathwayUpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePlugin;
import de.berlin.hu.ppi.update.plugin.StorePathwaysInDB;
import java.io.File;
import java.util.Date;

public class SpikePathwayUpdatePlugin
extends AbstractPathwayUpdatePlugin {
    private static UpdatePlugin instance = null;
    private static final String HTTP_FILE_LOCATION = "http://www.cs.tau.ac.il/~spike/download/spikeDB.owl.zip";

    private SpikePathwayUpdatePlugin() throws Exception {
        this.pluginName = "Spike Pathways";
        this.description = "This plugin updates the Spike data. SPIKE (Signaling Pathway Integrated Knowledge Engine) is an interactive software environment that graphically displays biological signaling networks, allows dynamic layout and navigation through these networks, and enables the superposition of DNA microarray and other functional genomics data on interaction maps.";
        this.checkForUpdates();
    }

    public static UpdatePlugin getInstance() throws Exception {
        if (instance == null) {
            instance = new SpikePathwayUpdatePlugin();
        }
        return instance;
    }

    @Override
    protected void runUpdate() throws Exception {
        File dir = this.setTargetDirectoryToTmpWithSubfolder();
        if (this.isInterrupted) {
            return;
        }
        this.startNextTask("Downloading");
        this.target = this.download(HTTP_FILE_LOCATION);
        this.startNextTask("Extracting");
        super.extractZip(this.target);
        this.db = StorePathwaysInDB.getInstance();
        this.db.establishConnection();
        this.setTaskDescription("Deleting old data...");
        this.db.deleteDataFromTables(PpiConstants.DB_ID.SPIKE);
        this.db.addSourceToDB(PpiConstants.DB_ID.SPIKE);
        this.db.closeConnection();
        if (!this.isInterrupted) {
            for (File file : FileTool.listAllFiles(dir)) {
                if (!file.getName().endsWith(".owl")) continue;
                this.startNextTask("Parsing " + file.getName());
                PathwayParser parser = new PathwayParser(true);
                try {
                    parser.parseFile(file.getAbsolutePath());
                }
                catch (FileParsingException e) {
                    if (e.getMessage().equals("No pathway found")) {
                        parser = new PathwayAbsentParser(true);
                        parser.parseFile(file.getAbsolutePath());
                    }
                }
                catch (Exception e) {
                    this.log.error("", e);
                }
                if (this.isInterrupted) {
                    return;
                }
                this.setTaskDescription("Loading " + file.getName());
                this.db.establishConnection();
                int pathwaysSize = parser.getPathwaysSize();
                this.setCounterFinish(pathwaysSize);
                for (int i = 0; i < pathwaysSize && !this.isInterrupted; ++i) {
                    this.db.loadPathwayIntoDb(parser.getPathway(i), this.uniquePathwayId++, null, PpiConstants.DB_ID.SPIKE);
                    this.incrementCounter();
                }
                this.db.closeConnection();
                this.db.storeNewTaxonIds();
            }
        }
        this.dateFetched.await();
        this.setUpdateTime("latestUpdate", this.updateDate);
    }

    @Override
    protected Date getUpdateDate() {
        try {
            return this.determineDate("spikeDB\\.owl\\.zip.*?align=.right.>", "http://www.cs.tau.ac.il/~spike/download", PpiConstants.DB_ID.SPIKE, "dd-MMM-yyyy HH:mm", 1);
        }
        catch (Exception e) {
            this.log.error("", e);
            return null;
        }
    }
}

