/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update.plugin;

import de.berlin.hu.ppi.update.AbstractUpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePlugin;
import java.io.File;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.log4j.Logger;

public final class ReactomeUpdatePlugin
extends AbstractUpdatePlugin {
    private static final String REACTOME = "reactome";
    private static final String UNIPROT_REACTOME = "uniprot_reactome";
    private static final int DOWNLOADING = 0;
    private static final int LOADING_DATASETS = 1;
    private int countedDatasets = 0;
    private File target;
    private static UpdatePlugin instance;
    private String url = "http://www.reactome.org/download/current/uniprot_2_pathways.stid.txt";

    private ReactomeUpdatePlugin() throws Exception {
        this.tableNames = new String[]{REACTOME};
        this.taskCount = 2;
        this.taskDescriptions = new String[]{"Downloading data file ...", "Loading data into database..."};
        this.pluginName = "Reactome";
        this.description = "This plugin updates Reactome data. Reactome is a free, online, open-source, curated resource of core pathways and reactions in human biology. [...] The curated human data are used to infer orthologous events in 22 non-human species including mouse, rat, chicken, puffer fish, worm, fly, yeast, two plants and E.coli.";
        this.log = Logger.getLogger(ReactomeUpdatePlugin.class);
        this.checkForUpdates();
    }

    public static UpdatePlugin getInstance() throws Exception {
        if (instance == null) {
            instance = new ReactomeUpdatePlugin();
        }
        return instance;
    }

    public boolean isUpdateAvailable(File targetfile) {
        return !targetfile.exists();
    }

    @Override
    public void runUpdate() throws SQLException {
        if (!this.isInterrupted) {
            this.openDatabaseConnection();
            this.connection.setAutoCommit(false);
            this.startTask(0);
            this.setTargetDirectoryToTmp();
            this.target = this.download(this.url);
        }
        if (!this.isInterrupted) {
            this.startTask(1);
            this.loadDatasets();
        }
    }

    private void loadDatasets() {
        try {
            String line;
            this.countDatasets();
            this.openReader(this.target);
            this.clearTables(UNIPROT_REACTOME, REACTOME);
            PreparedStatement insertReactome = this.connection.prepareStatement("INSERT INTO reactome VALUES (?,?)");
            PreparedStatement insertUniprotReactome = this.connection.prepareStatement("INSERT INTO uniprot_reactome VALUES (?, ?)");
            HashSet<String> reacts = new HashSet<String>();
            int insertedDatasets = 0;
            this.setCounterFinish(this.countedDatasets);
            while ((line = this.reader.readLine()) != null && !this.isInterrupted) {
                String[] items = line.split("\\t");
                String uniprotId = items[0];
                String reactomeId = items[1];
                String pathwayName = items[2];
                if (!reacts.contains(reactomeId)) {
                    reacts.add(reactomeId);
                    insertReactome.setString(1, reactomeId);
                    insertReactome.setString(2, pathwayName);
                    insertReactome.addBatch();
                    ++insertedDatasets;
                }
                insertUniprotReactome.setString(1, uniprotId);
                insertUniprotReactome.setString(2, reactomeId);
                insertUniprotReactome.addBatch();
                if (++insertedDatasets % this.getBatchSize() == 0) {
                    insertReactome.executeBatch();
                    insertUniprotReactome.executeBatch();
                }
                this.incrementCounter();
            }
            insertReactome.executeBatch();
            insertUniprotReactome.executeBatch();
            insertReactome.close();
        }
        catch (Exception e) {
            this.log.error(e);
            System.exit(0);
        }
    }

    private void countDatasets() {
        try {
            this.openReader(this.target);
            int oldCount = 0;
            try {
                oldCount = Integer.parseInt(this.getProperty("dataCount"));
            }
            catch (Exception e) {
                // empty catch block
            }
            this.setCounterFinish(oldCount);
            this.countedDatasets = 0;
            String line = this.reader.readLine();
            while (line != null && !this.isInterrupted) {
                ++this.countedDatasets;
                this.incrementCounter();
                line = this.reader.readLine();
            }
        }
        catch (IOException e) {
            this.log.error(e);
        }
        this.setProperty("dataCount", Integer.toString(this.countedDatasets));
    }

    @Override
    public UpdatePlugin.UpdateType getType() {
        return UpdatePlugin.UpdateType.META_DATA;
    }

    @Override
    protected int getCurrentUpdateHash() throws Exception {
        return this.computeHashCodeFromOnlineFiles(Arrays.asList(this.url));
    }
}

