/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update.plugin;

import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.parser.FileParsingException;
import de.berlin.hu.ppi.parser.PathwayAbsentParser;
import de.berlin.hu.ppi.parser.PathwayParser;
import de.berlin.hu.ppi.tool.FileTool;
import de.berlin.hu.ppi.tool.WebSiteParsingException;
import de.berlin.hu.ppi.tool.WebSiteTools;
import de.berlin.hu.ppi.update.AbstractPathwayUpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePlugin;
import de.berlin.hu.ppi.update.plugin.KeggPathwayUpdatePlugin;
import de.berlin.hu.ppi.update.plugin.StorePathwaysInDB;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ReactomePathwayUpdatePlugin
extends AbstractPathwayUpdatePlugin {
    public static final String URL_CURRENT_DATE = "http://reactome.oicr.on.ca/download/current/";
    private static UpdatePlugin instance = null;
    private static Logger log = Logger.getLogger(KeggPathwayUpdatePlugin.class);
    private static final String HTTP_FILE_LOCATION = "http://www.reactome.org/download/current/biopax.zip";

    private ReactomePathwayUpdatePlugin() throws Exception {
        this.pluginName = "Reactome Pathways";
        this.description = "This plugin updates the Reactome data. Reactome is a free, online, open-source, curated pathway database encompassing many areas of human biology.";
        this.taskCount = 10;
        this.checkForUpdates();
    }

    public static UpdatePlugin getInstance() throws Exception {
        if (instance == null) {
            instance = new ReactomePathwayUpdatePlugin();
        }
        return instance;
    }

    @Override
    protected void runUpdate() throws Exception {
        File dir = this.setTargetDirectoryToTmpWithSubfolder();
        if (this.isInterrupted) {
            return;
        }
        this.startNextTask("Downloading");
        this.target = this.download(HTTP_FILE_LOCATION);
        this.startNextTask("Extracting");
        super.extractZip(this.target);
        this.db = StorePathwaysInDB.getInstance();
        this.db.establishConnection();
        this.db.deleteDataFromTables(PpiConstants.DB_ID.REACTOME);
        this.db.addSourceToDB(PpiConstants.DB_ID.REACTOME);
        this.db.closeConnection();
        if (!this.isInterrupted) {
            List<File> files = FileTool.listAllFiles(dir);
            this.taskCount = 2 + files.size();
            for (File file : files) {
                if (!file.getName().endsWith(".owl")) continue;
                if (this.isInterrupted) {
                    return;
                }
                this.startNextTask("Parsing data");
                PathwayParser parser = new PathwayParser(true);
                try {
                    parser.parseFile(file.getAbsolutePath());
                }
                catch (FileParsingException e) {
                    if (e.getMessage().equals("No pathway found")) {
                        parser = new PathwayAbsentParser(true);
                        parser.parseFile(file.getAbsolutePath());
                    }
                    throw e;
                }
                if (this.isInterrupted) {
                    return;
                }
                this.setTaskDescription("Loading data");
                this.db.establishConnection();
                this.setCounterFinish(parser.getPathwaysSize());
                for (int i = 0; i < parser.getPathwaysSize() && !this.isInterrupted; ++i) {
                    this.db.loadPathwayIntoDb(parser.getPathway(i), this.uniquePathwayId++, null, PpiConstants.DB_ID.REACTOME);
                    this.incrementCounter();
                }
                this.db.closeConnection();
                this.db.storeNewTaxonIds();
            }
        }
        this.dateFetched.await();
        this.setUpdateTime("latestUpdate", this.updateDate);
    }

    public Date getCurrentDate() throws IOException, ParseException {
        BufferedReader reader = WebSiteTools.getUrlContent(URL_CURRENT_DATE);
        String line = reader.readLine();
        while (line != null) {
            if (line.contains("biopax.zip")) {
                String[] splitted = line.split("(<tr>.+</a></td><td align=\"right\">)|(</td>.+</tr>)");
                line = splitted[splitted.length - 1].trim();
                break;
            }
            line = reader.readLine();
        }
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy HH:mm", Locale.ENGLISH);
        Date output = null;
        output = df.parse(line);
        return output;
    }

    @Override
    protected Date getUpdateDate() {
        try {
            return this.getCurrentDate();
        }
        catch (WebSiteParsingException e) {
            e.printStackTrace();
        }
        catch (FileParsingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            log.error("", e);
        }
        catch (ParseException e) {
            log.error("", e);
        }
        return null;
    }
}

