/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update.plugin;

import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.parser.FileParsingException;
import de.berlin.hu.ppi.parser.PathwayAbsentParser;
import de.berlin.hu.ppi.parser.PathwayParser;
import de.berlin.hu.ppi.parser.PathwayStepAbsentParser;
import de.berlin.hu.ppi.tool.Extract;
import de.berlin.hu.ppi.tool.StringTransformationMethods;
import de.berlin.hu.ppi.tool.WebSiteParsingException;
import de.berlin.hu.ppi.tool.WebSiteTools;
import de.berlin.hu.ppi.update.AbstractPathwayUpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePlugin;
import de.berlin.hu.ppi.update.plugin.StorePathwaysInDB;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class PathwayCommonsUpdatePlugin
extends AbstractPathwayUpdatePlugin {
    private static UpdatePlugin instance = null;
    public static final String KEY_LAST_UPDATE_BIOGRID = "Biogrid.latestUpdate";
    public static final String KEY_LAST_UPDATE_CANCERCELLMAP = "Cancercellmap.latestUpdate";
    public static final String KEY_LAST_UPDATE_HPRD = "Hrpd.latestUpdate";
    public static final String KEY_LAST_UPDATE_IMID = "Imid.latestUpdate";
    public static final String KEY_LAST_UPDATE_INTACT = "Intact.latestUpdate";
    public static final String KEY_LAST_UPDATE_MINT = "Mint.latestUpdate";
    private Map<PpiConstants.DB_ID, DatabaseInfo> dbInfo;
    private Map<PpiConstants.DB_ID, String> dbUpdateKey;
    private Pattern owl = Pattern.compile("\\.owl");
    private Pattern idValue = Pattern.compile("name='source_id'\\svalue='", 2);
    private String searchString;
    private PpiConstants.DB_ID searchSubDb;
    private Logger log = Logger.getLogger(PathwayCommonsUpdatePlugin.class);

    private PathwayCommonsUpdatePlugin() throws Exception {
        this.pluginName = "Pathway Commons Pathways";
        this.description = "This plugin updates the Pathway Commons data. Pathway Commons is a convenient point of access to biological pathway information collected from public pathway databases, which you can browse or search.";
        this.dbInfo = new HashMap<PpiConstants.DB_ID, DatabaseInfo>();
        this.dbInfo.put(PpiConstants.DB_ID.PATHWAY_COMMONS_CANCERCELLMAP, new DatabaseInfo("http://www.pathwaycommons.org/pc/dbSnapshot.do?snapshot_id=8", false, "Cancer Cell Map, Release:"));
        this.dbInfo.put(PpiConstants.DB_ID.PATHWAY_COMMONS_HPRD, new DatabaseInfo("http://www.pathwaycommons.org/pc/dbSnapshot.do?snapshot_id=4", true, "HPRD"));
        this.dbInfo.put(PpiConstants.DB_ID.PATHWAY_COMMONS_INTACT, new DatabaseInfo("http://www.pathwaycommons.org/pc/dbSnapshot.do?snapshot_id=2", true, "IntAct"));
        this.dbInfo.put(PpiConstants.DB_ID.PATHWAY_COMMONS_MINT, new DatabaseInfo("http://www.pathwaycommons.org/pc/dbSnapshot.do?snapshot_id=3", true, "MINT"));
        this.dbInfo.put(PpiConstants.DB_ID.PATHWAY_COMMONS_BIOGRID, new DatabaseInfo("http://www.pathwaycommons.org/pc/dbSnapshot.do?snapshot_id=9", true, "BioGRID, Release:"));
        this.dbInfo.put(PpiConstants.DB_ID.PATHWAY_COMMONS_IMID, new DatabaseInfo("http://www.pathwaycommons.org/pc/dbSnapshot.do?snapshot_id=10", true, "IMID, Release:"));
        this.dbUpdateKey = new HashMap<PpiConstants.DB_ID, String>();
        this.dbUpdateKey.put(PpiConstants.DB_ID.PATHWAY_COMMONS_CANCERCELLMAP, KEY_LAST_UPDATE_CANCERCELLMAP);
        this.dbUpdateKey.put(PpiConstants.DB_ID.PATHWAY_COMMONS_HPRD, KEY_LAST_UPDATE_HPRD);
        this.dbUpdateKey.put(PpiConstants.DB_ID.PATHWAY_COMMONS_INTACT, KEY_LAST_UPDATE_INTACT);
        this.dbUpdateKey.put(PpiConstants.DB_ID.PATHWAY_COMMONS_MINT, KEY_LAST_UPDATE_MINT);
        this.dbUpdateKey.put(PpiConstants.DB_ID.PATHWAY_COMMONS_BIOGRID, KEY_LAST_UPDATE_BIOGRID);
        this.dbUpdateKey.put(PpiConstants.DB_ID.PATHWAY_COMMONS_IMID, KEY_LAST_UPDATE_IMID);
        this.checkForUpdates();
    }

    public static UpdatePlugin getInstance() throws Exception {
        if (instance == null) {
            instance = new PathwayCommonsUpdatePlugin();
        }
        return instance;
    }

    @Override
    protected void runUpdate() throws Exception {
        this.dateFetched.await();
        try {
            this.taskCount = this.estimateTaskCount();
            this.log.info(String.format("%d number of files found.", this.taskCount));
        }
        catch (Exception e) {
            this.log.error("", e);
            this.taskCount = 10;
        }
        for (PpiConstants.DB_ID dbId : this.dbInfo.keySet()) {
            if (this.isInterrupted) {
                return;
            }
            this.db = StorePathwaysInDB.getInstance();
            this.db.establishConnection();
            this.db.deleteDataFromTables(dbId);
            this.db.addSourceToDB(dbId);
            this.db.closeConnection();
            List<SubDatabaseInfo> links = this.createLinks(dbId, this.dbInfo.get((Object)((Object)dbId)).url);
            File dir = this.setTargetDirectoryToTmp(this.getClass().getSimpleName() + File.separatorChar + dbId.name());
            if (!dir.exists()) {
                this.log.error("Temporary directory for extracting biocyc xml files could not be created.");
                throw new IOException("Temporary directory for extracting biocyc xml files could not be created.");
            }
            for (SubDatabaseInfo subDatabaseInfo : links) {
                if (this.isInterrupted) continue;
                this.startNextTask();
                this.setTaskDescription("Downloading");
                this.target = this.download(subDatabaseInfo.url);
                String file = this.target.getAbsolutePath();
                String extractedFile = file.substring(0, file.length() - 3);
                Extract.extractGZipFile(file, extractedFile);
                this.setTaskDescription("Parsing data");
                PathwayParser parser = new PathwayStepAbsentParser(this.dbInfo.get((Object)((Object)dbId)).prefix);
                try {
                    this.log.trace("Extracted file: " + extractedFile);
                    parser.parseFile(extractedFile);
                }
                catch (FileParsingException e) {
                    if (e.getMessage().equals("No pathway found")) {
                        parser = new PathwayAbsentParser(true);
                        parser.parseFile(extractedFile);
                    }
                    throw e;
                }
                this.startNextTask("Loading Data");
                this.db.establishConnection();
                this.setCounterFinish(parser.getPathwaysSize());
                for (int i = 0; i < parser.getPathwaysSize() && !this.isInterrupted; ++i) {
                    this.db.loadPathwayIntoDb(parser.getPathway(i), this.uniquePathwayId++, subDatabaseInfo.date, dbId);
                    this.incrementCounter();
                }
                this.db.closeConnection();
                this.db.storeNewTaxonIds();
            }
            this.setUpdateTime(this.dbUpdateKey.get((Object)dbId), this.dbInfo.get((Object)((Object)dbId)).updateDate);
        }
    }

    public int estimateTaskCount() throws WebSiteParsingException, FileParsingException, InterruptedException, ParseException {
        int value = 0;
        for (PpiConstants.DB_ID dbId : this.dbInfo.keySet()) {
            if (!this.dbInfo.get((Object)((Object)dbId)).updateAvailable) continue;
            value += this.createLinks(dbId, this.dbInfo.get((Object)((Object)dbId)).url).size();
        }
        return value * 2;
    }

    private List<SubDatabaseInfo> createLinks(PpiConstants.DB_ID dbId, String url) throws WebSiteParsingException, InterruptedException, FileParsingException, ParseException {
        WebSiteTools webTool = new WebSiteTools(10000);
        Scanner scanner = webTool.tryToLoadWebSite(url, dbId.name());
        scanner.useDelimiter(this.owl);
        if (!scanner.hasNext()) {
            throw new FileParsingException("No *.owl file found");
        }
        ArrayList<SubDatabaseInfo> links = new ArrayList<SubDatabaseInfo>();
        while (scanner.hasNext()) {
            String tmp = scanner.next();
            int position = tmp.lastIndexOf("<td>");
            if (position != -1) {
                String name = tmp.substring(position + 4).trim();
                StringTransformationMethods.processToNextDelimiter(scanner.useDelimiter("<td>"), "No date found");
                StringTransformationMethods.processToNextDelimiter(scanner.useDelimiter("<td>"), "No date found");
                String date = StringTransformationMethods.processToNextDelimiter(scanner.useDelimiter("</td>"), "No date found");
                date = date.substring(4).trim();
                StringTransformationMethods.processToNextDelimiter(scanner.useDelimiter(this.idValue), "Html structure changed or is faulty");
                String id = StringTransformationMethods.processToNextDelimiter(scanner.useDelimiter("'>"), "Html structure changed or is faulty");
                id = id.substring(24);
                SubDatabaseInfo subDatabaseInfo = new SubDatabaseInfo("http://www.pathwaycommons.org/pc/downloadSource.do?source_id=" + id, name, this.parseDate("dd-MMM-yy", date, dbId));
                links.add(subDatabaseInfo);
            }
            scanner.useDelimiter(this.owl);
        }
        scanner.close();
        return links;
    }

    @Override
    protected Date getUpdateDate() {
        try {
            this.log.trace("trying to get update date");
            return this.determineDate(this.searchString, "http://www.pathwaycommons.org/pc/dbSources.do", this.searchSubDb, "dd-MMM-yy", 0);
        }
        catch (Exception e) {
            this.log.error("", e);
            return null;
        }
    }

    @Override
    protected void checkForUpdates() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                for (PpiConstants.DB_ID dbId : PathwayCommonsUpdatePlugin.this.dbInfo.keySet()) {
                    DatabaseInfo info = (DatabaseInfo)PathwayCommonsUpdatePlugin.this.dbInfo.get((Object)dbId);
                    PathwayCommonsUpdatePlugin.this.searchString = info.updateSearchString;
                    PathwayCommonsUpdatePlugin.this.searchSubDb = dbId;
                    info.updateDate = PathwayCommonsUpdatePlugin.this.getUpdateDate();
                    Date lastUpdateDate = PathwayCommonsUpdatePlugin.this.getUpdateTime((String)PathwayCommonsUpdatePlugin.this.dbUpdateKey.get((Object)dbId));
                    if (lastUpdateDate == null || info.updateDate != null && lastUpdateDate.before(info.updateDate)) {
                        info.updateAvailable = true;
                        PathwayCommonsUpdatePlugin.this.isUpdateAvailable = true;
                        continue;
                    }
                    info.updateAvailable = false;
                }
                PathwayCommonsUpdatePlugin.this.dateFetched.countDown();
            }
        }).start();
    }

    private class SubDatabaseInfo {
        public String url;
        public String name;
        public Date date;

        public SubDatabaseInfo(String url, String name, Date date) {
            this.url = url;
            this.name = name;
            this.date = date;
        }
    }

    private class DatabaseInfo {
        public String url;
        public boolean prefix;
        public boolean updateAvailable;
        public Date updateDate;
        public String updateSearchString;

        public DatabaseInfo(String url, boolean prefix, String updateSearchString) {
            this.url = url;
            this.prefix = prefix;
            this.updateSearchString = updateSearchString;
        }
    }
}

