/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update.plugin;

import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.parser.PathwayStepAbsentParser;
import de.berlin.hu.ppi.tool.Extract;
import de.berlin.hu.ppi.update.AbstractPathwayUpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePlugin;
import de.berlin.hu.ppi.update.plugin.KeggPathwayUpdatePlugin;
import de.berlin.hu.ppi.update.plugin.StorePathwaysInDB;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PIDPathwayUpdatePlugin
extends AbstractPathwayUpdatePlugin {
    private static UpdatePlugin instance = null;
    private static final String KEY_LAST_UPDATE_NCI = "NCI.latestUpdate";
    private static final String KEY_LAST_UPDATE_BIOCARTA = "BioCarta.latestUpdate";
    private static final String KEY_LAST_UPDATE_REACTOME = "Reactome.latestUpdate";
    private static final String FTP_FILE_LOCATION1 = "ftp://ftp1.nci.nih.gov/pub/PID/BioPAX/NCI-Nature_Curated.owl.gz";
    private static final String FTP_FILE_LOCATION2 = "ftp://ftp1.nci.nih.gov/pub/PID/BioPAX/BioCarta.owl.gz";
    private static final String FTP_FILE_LOCATION3 = "ftp://ftp1.nci.nih.gov/pub/PID/BioPAX/Reactome.owl.gz";
    private Map<PpiConstants.DB_ID, DatabaseInfo> dbInfo;
    private static Logger log = Logger.getLogger(KeggPathwayUpdatePlugin.class);

    private PIDPathwayUpdatePlugin() throws Exception {
        this.pluginName = "PID Pathways";
        this.description = "This plugin updates the PID data. The Pathway Interaction Database is a highly-structured, curated collection of information about known biomolecular interactions and key cellular processes assembled into signaling pathways.";
        this.dbInfo = new HashMap<PpiConstants.DB_ID, DatabaseInfo>();
        this.dbInfo.put(PpiConstants.DB_ID.PATHWAY_INTERACTION_DATABASE_NCI, new DatabaseInfo(FTP_FILE_LOCATION1, KEY_LAST_UPDATE_NCI));
        this.dbInfo.put(PpiConstants.DB_ID.PATHWAY_INTERACTION_DATABASE_BIOCARTA, new DatabaseInfo(FTP_FILE_LOCATION2, KEY_LAST_UPDATE_BIOCARTA));
        this.dbInfo.put(PpiConstants.DB_ID.PATHWAY_INTERACTION_DATABASE_REACTOME, new DatabaseInfo(FTP_FILE_LOCATION3, KEY_LAST_UPDATE_REACTOME));
        this.taskCount = this.dbInfo.size() * 2;
        this.checkForUpdates();
    }

    public static UpdatePlugin getInstance() throws Exception {
        if (instance == null) {
            instance = new PIDPathwayUpdatePlugin();
        }
        return instance;
    }

    @Override
    protected void runUpdate() throws Exception {
        for (PpiConstants.DB_ID dbId : this.dbInfo.keySet()) {
            this.startNextTask();
            this.setTaskDescription("Downloading");
            if (this.isInterrupted) {
                return;
            }
            this.setTargetDirectoryToTmpWithSubfolder();
            this.target = this.download(this.dbInfo.get((Object)((Object)dbId)).url);
            String file = this.target.getAbsolutePath();
            String extractedFile = file.substring(0, file.length() - 3);
            Extract.extractGZipFile(file, extractedFile);
            this.db = StorePathwaysInDB.getInstance();
            this.db.establishConnection();
            this.db.deleteDataFromTables(dbId);
            this.db.addSourceToDB(dbId);
            this.db.closeConnection();
            if (this.isInterrupted) {
                return;
            }
            this.startNextTask();
            this.setTaskDescription("Parsing data");
            PathwayStepAbsentParser parser = new PathwayStepAbsentParser(true);
            parser.parseFile(extractedFile);
            if (this.isInterrupted) {
                return;
            }
            this.setTaskDescription("Loading data");
            this.db.establishConnection();
            this.setCounterFinish(parser.getPathwaysSize());
            for (int i = 0; i < parser.getPathwaysSize() && !this.isInterrupted; ++i) {
                this.db.loadPathwayIntoDb(parser.getPathway(i), this.uniquePathwayId++, null, dbId);
                this.incrementCounter();
            }
            this.db.closeConnection();
            this.db.storeNewTaxonIds();
            this.dateFetched.await();
            this.setUpdateTime(this.dbInfo.get((Object)((Object)dbId)).lastUpdateString, this.updateDate);
            if (!this.isInterrupted) continue;
            return;
        }
    }

    @Override
    protected Date getUpdateDate() {
        try {
            return this.determineDate("Date last updated:", "http://pid.nci.nih.gov/", PpiConstants.DB_ID.PATHWAY_INTERACTION_DATABASE_NCI, "dd MMMM yyyy", 0);
        }
        catch (Exception e) {
            log.error("", e);
            return null;
        }
    }

    private class DatabaseInfo {
        public String url;
        public String lastUpdateString;

        public DatabaseInfo(String url, String lastUpdateString) {
            this.url = url;
            this.lastUpdateString = lastUpdateString;
        }
    }
}

