/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update.plugin;

import de.berlin.hu.ppi.parser.omim.OmimSubtype;
import de.berlin.hu.ppi.update.AbstractUpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public final class OmimUpdatePlugin
extends AbstractUpdatePlugin {
    private static final String RESSOURCE_SUBTYPES_CLASSES_TXT = "de/berlin/hu/ppi/omim_subtypes_classes.txt";
    private static final int DOWNLOADING_OMIM = 0;
    private static final int PARSING_OMIM = 1;
    private static final int DOWNLOADING_MORBIDMAP = 2;
    private static final int PARSING_MORBIDMAP = 3;
    private static final int LOADING_DATASETS = 4;
    private static final String OMIM_DISEASE = "omim_disease";
    private static final String OMIM_LOCUS = "omim_locus";
    private static final String OMIM_REL = "omim_rel";
    private static final String OMIM_DISEASE_TYPE = "omim_disease_type";
    private double deflateFactor = 2.2661065250185426;
    private static UpdatePlugin instance;
    private Map<String, String> prefixes = new HashMap<String, String>();
    private Map<String, String> moved = new HashMap<String, String>();
    private Map<String, Set<String>> loci = new HashMap<String, Set<String>>();
    private Map<Integer, Set<Integer>> rels = new HashMap<Integer, Set<Integer>>();
    private File omim_txt;
    private File morbidmap;
    private Map<String, OmimSubtype> subTypeMap;
    private static final String insertSubTypes = "insert into %s values (?, ?, ?)";
    private boolean skipDownload = false;
    private String omimTxtPath = "/vol/home-vol3/wbi/wbi_stud/ppi_data/OmimUpdatePlugin/omim.txt.Z";
    private String urlOmim = "ftp://ftp.ncbi.nih.gov/repository/OMIM/ARCHIVE/omim.txt.Z";
    private String urlMorbidMap = "ftp://ftp.ncbi.nih.gov/repository/OMIM/ARCHIVE/morbidmap";

    private OmimUpdatePlugin() throws Exception {
        this.taskCount = 6;
        this.taskDescriptions = new String[]{"Downloading", "Parsing omim.txt ...", "Downloading ", "Parsing morbidmap data...", "Loading data into database..."};
        this.pluginName = "OMIM";
        this.description = "This plugin updates OMIM data. OMIM is a comprehensive, authoritative, and timely compendium of human genes and genetic phenotypes. The full-text, referenced overviews in OMIM contain information on all known mendelian disorders and over 12,000 genes. OMIM focuses on the relationship between phenotype and genotype.";
        this.log = Logger.getLogger(OmimUpdatePlugin.class);
        this.checkForUpdates();
    }

    public static UpdatePlugin getInstance() throws Exception {
        if (instance == null) {
            instance = new OmimUpdatePlugin();
        }
        return instance;
    }

    @Override
    public void runUpdate() throws SQLException, IOException {
        if (!this.isInterrupted) {
            this.startTask(0);
            this.setTargetDirectoryToTmp();
            this.omim_txt = this.skipDownload ? new File(this.omimTxtPath) : this.downloadViaUrl(this.urlOmim, true);
        }
        if (!this.isInterrupted) {
            this.startTask(1);
            this.openDatabaseConnection();
            this.clearTables(OMIM_LOCUS, OMIM_REL, OMIM_DISEASE);
            this.parseOmim();
        }
        if (!this.isInterrupted) {
            this.startTask(2);
            this.morbidmap = this.downloadViaUrl(this.urlMorbidMap, true);
        }
        if (!this.isInterrupted) {
            this.startTask(3);
            this.parseMorbidMap();
        }
        if (!this.isInterrupted) {
            this.startTask(4);
            this.loadDataSets();
        }
        if (!this.isInterrupted) {
            this.startNextTask("Inserting Omim Subtypes...");
            this.insertOmimSubtypes(this.connection);
        }
    }

    private void insertOmimSubtypes(Connection con) throws IOException, SQLException {
        String name = RESSOURCE_SUBTYPES_CLASSES_TXT;
        InputStream input = ClassLoader.getSystemResourceAsStream(name);
        this.parserOmimSubtype(input);
        this.setCounterFinish(this.subTypeMap.size());
        String sql = String.format(insertSubTypes, OMIM_DISEASE_TYPE);
        PreparedStatement prepareStatement = con.prepareStatement(sql);
        for (String omimId : this.subTypeMap.keySet()) {
            OmimSubtype type = this.subTypeMap.get(omimId);
            List<Integer> diseaseSubtypes = type.getDiseaseSubtypes();
            List<String> diseaseClasses = type.getDiseaseClass();
            for (int i = 0; i < diseaseSubtypes.size(); ++i) {
                prepareStatement.setString(1, omimId);
                prepareStatement.setString(2, diseaseClasses.get(i));
                prepareStatement.setInt(3, diseaseSubtypes.get(i));
                prepareStatement.addBatch();
                try {
                    prepareStatement.executeBatch();
                    continue;
                }
                catch (Exception e) {
                    if (i != diseaseSubtypes.size() - 1) continue;
                    this.log.error("", e);
                }
            }
            this.incrementCounter();
        }
    }

    public boolean isUpdateAvailable(File targetfile) {
        return !targetfile.exists();
    }

    private void parseOmim() {
        if (this.isInterrupted) {
            return;
        }
        try {
            this.connection.setAutoCommit(true);
            int insertOmimDiseaseCount = 0;
            PreparedStatement insertOmimDisease = this.connection.prepareStatement("INSERT INTO omim_disease (omim_id, omim_id_prefix, phenotype_description) VALUES (?,?,?)");
            String absolutePath = this.omim_txt.getAbsolutePath();
            Process p = Runtime.getRuntime().exec("gunzip -c " + absolutePath);
            this.setCounterFinish((long)((double)this.omim_txt.length() * this.deflateFactor));
            this.log.debug("Starting omim read");
            this.openReader(p.getInputStream());
            String line = this.reader.readLine();
            while (line != null && !this.isInterrupted) {
                this.increaseCounter(line.length());
                if (line.contains("*FIELD* TI")) {
                    String[] omim_split;
                    line = this.reader.readLine();
                    if (line.startsWith("^")) {
                        omim_split = line.split(" ");
                        String from_id = omim_split[0].substring(1);
                        String to_id = omim_split[omim_split.length - 1];
                        this.moved.put(from_id, to_id);
                    } else {
                        omim_split = line.split(" ");
                        String mim_id = omim_split[0];
                        String type = "";
                        if (mim_id.length() == 7) {
                            type = mim_id.substring(0, 1);
                            mim_id = mim_id.substring(1, mim_id.length());
                        }
                        this.prefixes.put(mim_id, type);
                        if (!type.equals("*")) {
                            String description = line.substring(omim_split[0].length() + 1);
                            line = this.reader.readLine();
                            if (!line.startsWith("*") && !line.startsWith(";")) {
                                description = description + " " + line;
                            }
                            insertOmimDisease.setInt(1, Integer.parseInt(mim_id));
                            insertOmimDisease.setString(2, type.toString());
                            insertOmimDisease.setString(3, description);
                            insertOmimDisease.addBatch();
                            if (++insertOmimDiseaseCount % this.getBatchSize() == 0) {
                                this.log.info("Prepared-Statement: Batch execution...");
                                insertOmimDisease.executeBatch();
                            }
                        }
                    }
                }
                line = this.reader.readLine();
            }
            if (!this.isInterrupted) {
                insertOmimDisease.executeBatch();
                this.log.debug("Ending omim read");
            }
        }
        catch (Exception e) {
            this.log.error("", e);
        }
    }

    private void loadDataSets() {
        try {
            int insertOmimRelCount = 0;
            int insertOmimLucusCount = 0;
            PreparedStatement insertOmimLocus = this.connection.prepareStatement("INSERT INTO omim_locus (omim_id, locus) VALUES (?,?)");
            PreparedStatement insertOmimRel = this.connection.prepareStatement("INSERT INTO omim_rel (omim_id, omim_genotype) VALUES (?,?)");
            this.setCounterFinish(this.loci.keySet().size() + this.rels.keySet().size());
            for (String pheno : this.loci.keySet()) {
                if (this.isInterrupted) break;
                this.incrementCounter();
                for (String locus : this.loci.get(pheno)) {
                    insertOmimLocus.setInt(1, Integer.parseInt(pheno));
                    insertOmimLocus.setString(2, locus);
                    insertOmimLocus.addBatch();
                    if (++insertOmimLucusCount % this.getBatchSize() != 0) continue;
                    insertOmimLocus.executeBatch();
                }
            }
            Iterator<Object> i$ = this.rels.keySet().iterator();
            while (i$.hasNext()) {
                int pheno = (Integer)i$.next();
                Iterator<Object> i$2 = this.rels.get(pheno).iterator();
                while (i$2.hasNext()) {
                    int rel = (Integer)i$2.next();
                    insertOmimRel.setInt(1, pheno);
                    insertOmimRel.setInt(2, rel);
                    insertOmimRel.addBatch();
                    if (++insertOmimRelCount % this.getBatchSize() != 0) continue;
                    insertOmimRel.executeBatch();
                }
            }
            if (!this.isInterrupted) {
                insertOmimRel.executeBatch();
                insertOmimLocus.executeBatch();
            }
        }
        catch (SQLException e) {
            this.log.error("", e);
        }
    }

    private void parseMorbidMap() {
        this.setCounterFinish(this.morbidmap.length());
        if (this.isInterrupted) {
            return;
        }
        this.openReader(this.morbidmap);
        try {
            String line;
            block2: while ((line = this.reader.readLine()) != null) {
                this.increaseCounter(line.length() + 1);
                if (!this.isInterrupted) {
                    int phenoInt;
                    String[] items = line.split("\\|");
                    String pheno = items[0];
                    String rel_id = items[2];
                    String locus = items[3];
                    String pheno_id = null;
                    String[] pheno_split = pheno.split("\\s+");
                    for (int i = 0; i < pheno_split.length; ++i) {
                        if (!pheno_split[i].matches("\\d{6}")) continue;
                        if (pheno_id != null) {
                            this.log.info("More than 1 id in pheno: " + line);
                            continue block2;
                        }
                        pheno_id = pheno_split[i];
                    }
                    if (pheno_id != null && this.moved.get(pheno_id) != null) {
                        pheno_id = this.moved.get(pheno_id);
                    }
                    if (rel_id != null && this.moved.get(rel_id) != null) {
                        rel_id = this.moved.get(rel_id);
                    }
                    rel_id = rel_id.trim();
                    String pheno_type = null;
                    String rel_type = null;
                    if (pheno_id == null && !rel_id.equals("")) {
                        rel_type = this.prefixes.get(rel_id);
                        if (rel_type == null) {
                            this.log.debug("rel_type is null!" + rel_id);
                            continue;
                        }
                        if (rel_type.equals("+")) {
                            pheno_id = rel_id;
                            pheno_type = rel_type;
                        }
                    } else if (rel_id.equals("") && pheno_id != null) {
                        pheno_type = this.prefixes.get(pheno_id);
                        if (pheno_type == null) {
                            this.log.debug("pheno_type is null!" + rel_id);
                            continue;
                        }
                        if (pheno_type.equals("+")) {
                            rel_id = pheno_id;
                            rel_type = pheno_type;
                        }
                    }
                    if (pheno_id == null && !rel_id.trim().isEmpty()) {
                        if (!"%".equals(rel_type)) continue;
                        if (!this.loci.containsKey(rel_id)) {
                            this.loci.put(rel_id, new HashSet());
                        }
                        this.loci.get(rel_id).add(locus);
                        continue;
                    }
                    if (rel_id.equals("") || pheno_id == null) {
                        this.log.debug("pheno_id or rel_id is null");
                        continue;
                    }
                    pheno_id = pheno_id.trim();
                    pheno_type = pheno_type != null ? pheno_type : this.prefixes.get(pheno_id);
                    String string = rel_type = rel_type != null ? rel_type : this.prefixes.get(rel_id);
                    if (pheno_type == null || rel_type == null) {
                        this.log.debug("pheno_type or rel_type is null");
                        continue;
                    }
                    if (pheno_type.equals("*") || rel_type.equals("#") || rel_type.equals("%") || pheno_type.equals("+") && rel_type.equals("+") && !pheno_id.equals(rel_id)) {
                        this.log.info("Strange combination of omim_id prefixes found in morbismap: pheno '" + pheno_type + pheno_id + "', geno '" + rel_type + rel_id + "'");
                        continue;
                    }
                    if (!this.loci.containsKey(pheno_id)) {
                        this.loci.put(pheno_id, new HashSet());
                    }
                    if (!this.rels.containsKey(phenoInt = Integer.parseInt(pheno_id))) {
                        this.rels.put(phenoInt, new HashSet());
                    }
                    int relInt = Integer.parseInt(rel_id);
                    this.loci.get(pheno_id).add(locus);
                    this.rels.get(phenoInt).add(relInt);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.log.error("", e);
        }
    }

    public void parserOmimSubtype(InputStream input) throws IOException {
        this.subTypeMap = new HashMap<String, OmimSubtype>();
        Matcher matcher = Pattern.compile("\\d{6}").matcher("");
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        reader.readLine();
        String line = reader.readLine();
        StringBuilder builder = new StringBuilder();
        while (line != null) {
            String[] splittedLine = line.split(",?\\s+");
            int length = splittedLine.length;
            for (int i = 1; i < length - 1; ++i) {
                String omimId = splittedLine[i];
                if (!matcher.reset(omimId).matches()) continue;
                int diseaseSubtype = Integer.parseInt(splittedLine[0]);
                String diseaseClass = OmimUpdatePlugin.getDiseaseClass(splittedLine, builder);
                OmimSubtype subtype = this.subTypeMap.get(omimId);
                if (subtype == null) {
                    subtype = new OmimSubtype();
                    subtype.setOmimId(omimId);
                    this.subTypeMap.put(omimId, subtype);
                }
                subtype.addRecord(diseaseClass, diseaseSubtype);
                break;
            }
            line = reader.readLine();
        }
    }

    public static String getDiseaseClass(String[] splitted, StringBuilder builder) {
        int last = splitted.length - 1;
        builder.setLength(0);
        Matcher matcher = Pattern.compile("c|(Chr.(\\d\\d?|X|Y))|((\\d\\d?|X|Y)(p|q|cen)(.*))").matcher("");
        int i = last;
        while (!matcher.reset(splitted[i]).matches()) {
            --i;
        }
        for (int j = i + 1; j < last; ++j) {
            builder.append(splitted[j]);
            builder.append(' ');
        }
        builder.append(splitted[last]);
        return builder.toString();
    }

    @Override
    public UpdatePlugin.UpdateType getType() {
        return UpdatePlugin.UpdateType.META_DATA;
    }

    @Override
    protected int getCurrentUpdateHash() throws Exception {
        return this.computeHashCodeFromOnlineFiles(Arrays.asList(this.urlMorbidMap, this.urlOmim));
    }
}

