/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update.plugin;

import de.berlin.hu.ppi.update.AbstractUpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class NewOmimUpdatePlugin
extends AbstractUpdatePlugin {
    private static final String INSERT_INTO_OMIM_DISEASE = "INSERT INTO %s (omim_id, omim_id_prefix, phenotype_description) VALUES (?,?,?)";
    private static final int DOWNLOADING_OMIM = 0;
    private static final int PARSING_OMIM = 1;
    private static final int DOWNLOADING_MORBIDMAP = 2;
    private static final int PARSING_MORBIDMAP = 3;
    private static final int LOADING_DATASETS = 4;
    private static final String OMIM_DISEASE = "omim_disease";
    private static final String OMIM_LOCUS = "omim_locus";
    private static final String OMIM_REL = "omim_rel";
    private static UpdatePlugin instance;
    private Map<String, String> prefixes = new HashMap<String, String>();
    private Map<String, String> moved = new HashMap<String, String>();
    private Map<String, Set<String>> loci = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> rels = new HashMap<String, Set<String>>();
    private File morbidmap;
    String urlOmim = "ftp://ftp.ncbi.nih.gov/repository/OMIM/omim.txt.Z";
    String urlMoridMap = "ftp://ftp.ncbi.nih.gov/repository/OMIM/morbidmap";

    private NewOmimUpdatePlugin() throws Exception {
        this.taskCount = 5;
        this.taskDescriptions = new String[]{"Downloading", "Parsing omim.txt ...", "Downloading ", "Parsing morbidmap data...", "Loading data into database..."};
        this.pluginName = "OMIM";
        this.description = "This plugin updates OMIM data. OMIM is a comprehensive, authoritative, and timely compendium of human genes and genetic phenotypes. The full-text, referenced overviews in OMIM contain information on all known mendelian disorders and over 12,000 genes. OMIM focuses on the relationship between phenotype and genotype.";
        this.log = Logger.getLogger(NewOmimUpdatePlugin.class);
        this.checkForUpdates();
    }

    public static UpdatePlugin getInstance() throws Exception {
        if (instance == null) {
            instance = new NewOmimUpdatePlugin();
        }
        return instance;
    }

    @Override
    public void runUpdate() throws SQLException {
        if (!this.isInterrupted) {
            this.startTask(0);
            this.setTargetDirectoryToTmp();
        }
        if (!this.isInterrupted) {
            this.startTask(1);
            this.openDatabaseConnection();
            this.parseOmim();
        }
        if (!this.isInterrupted) {
            this.startTask(2);
            this.morbidmap = this.download(this.urlMoridMap);
        }
        if (!this.isInterrupted) {
            this.startTask(3);
            this.parseMorbidMap();
        }
        if (!this.isInterrupted) {
            this.startTask(4);
            this.loadDataSets();
        }
    }

    public boolean isUpdateAvailable(File targetfile) {
        return !targetfile.exists();
    }

    private void parseOmim() {
        if (this.isInterrupted) {
            return;
        }
        try {
            this.connection.setAutoCommit(false);
            int insertOmimDiseaseCount = 0;
            String insertOmimDesease = String.format(INSERT_INTO_OMIM_DISEASE, OMIM_DISEASE);
            PreparedStatement insertOmimDisease = this.connection.prepareStatement(insertOmimDesease);
            FileInputStream inputStream = new FileInputStream("/vol/fob-vol5/mi06/arzt/Desktop/omim/omim.txt");
            this.openReader(inputStream);
            String line = this.reader.readLine();
            while (line != null && !this.isInterrupted) {
                this.increaseCounter(line.length());
                if (line.contains("*FIELD* TI")) {
                    String[] omim_split;
                    line = this.reader.readLine();
                    if (line.startsWith("^")) {
                        omim_split = line.split(" ");
                        String from_id = omim_split[0].substring(1);
                        String to_id = omim_split[omim_split.length - 1];
                        this.moved.put(from_id, to_id);
                    } else {
                        omim_split = line.split(" ");
                        String mim_id = omim_split[0];
                        String type = "";
                        if (mim_id.length() == 7) {
                            type = mim_id.substring(0, 1);
                            mim_id = mim_id.substring(1, mim_id.length());
                        }
                        this.prefixes.put(mim_id, type);
                        if (!type.equals("*")) {
                            String description = line.substring(omim_split[0].length() + 1);
                            line = this.reader.readLine();
                            if (!line.startsWith("*") && !line.startsWith(";")) {
                                description = description + " " + line;
                            }
                            int omimId = Integer.parseInt(mim_id);
                            insertOmimDisease.setInt(1, omimId);
                            insertOmimDisease.setString(2, type);
                            insertOmimDisease.setString(3, description);
                            insertOmimDisease.addBatch();
                            if (++insertOmimDiseaseCount % this.getBatchSize() == 0) {
                                this.log.info("Prepared-Statement: Batch execution...");
                                insertOmimDisease.executeBatch();
                            }
                        }
                    }
                }
                line = this.reader.readLine();
            }
            if (!this.isInterrupted) {
                insertOmimDisease.executeBatch();
                this.log.debug("Ending omim read");
            }
        }
        catch (Exception e) {
            this.log.error("", e);
        }
    }

    private void loadDataSets() {
        try {
            int insertOmimRelCount = 0;
            int insertOmimLucusCount = 0;
            PreparedStatement insertOmimLocus = this.connection.prepareStatement("INSERT INTO omim_locus (omim_id, locus) VALUES (?,?)");
            PreparedStatement insertOmimRel = this.connection.prepareStatement("INSERT INTO omim_rel (omim_id, omim_genotype) VALUES (?,?)");
            this.setCounterFinish(this.loci.keySet().size());
            for (String pheno : this.loci.keySet()) {
                if (this.isInterrupted) break;
                this.incrementCounter();
                for (String rel : this.rels.get(pheno)) {
                    insertOmimRel.setInt(1, Integer.parseInt(pheno));
                    insertOmimRel.setInt(2, Integer.parseInt(rel));
                    insertOmimRel.addBatch();
                    if (++insertOmimRelCount % this.getBatchSize() != 0) continue;
                    insertOmimRel.executeBatch();
                }
                for (String locus : this.loci.get(pheno)) {
                    insertOmimLocus.setInt(1, Integer.parseInt(pheno));
                    insertOmimLocus.setString(2, locus);
                    insertOmimLocus.addBatch();
                    if (++insertOmimLucusCount % this.getBatchSize() != 0) continue;
                    insertOmimLocus.executeBatch();
                }
            }
            if (!this.isInterrupted) {
                insertOmimRel.executeBatch();
                insertOmimLocus.executeBatch();
            }
        }
        catch (SQLException e) {
            this.log.error("", e);
        }
    }

    private void parseMorbidMap() {
        this.setCounterFinish(this.morbidmap.length());
        if (this.isInterrupted) {
            return;
        }
        this.openReader(this.morbidmap);
        try {
            String line;
            block2: while ((line = this.reader.readLine()) != null) {
                this.increaseCounter(line.length() + 1);
                if (!this.isInterrupted) {
                    String[] split = line.split("\\s*[|]\\s*");
                    String pheno = split[0];
                    String relId = split[2];
                    String locus = split[3];
                    String phenoId = null;
                    String[] phenoSplit = pheno.split("\\s+");
                    for (int i = 0; i < phenoSplit.length; ++i) {
                        if (!phenoSplit[i].matches("\\d{6}")) continue;
                        if (phenoId != null) {
                            this.log.info("More than 1 id in pheno: " + line);
                            continue block2;
                        }
                        phenoId = phenoSplit[i];
                    }
                    if (phenoId != null && this.moved.get(phenoId) != null) {
                        phenoId = this.moved.get(phenoId);
                    }
                    if (relId != null && this.moved.get(relId) != null) {
                        relId = this.moved.get(relId);
                    }
                    String phenoPrefix = null;
                    String relPrefix = null;
                    if (phenoId == null && !relId.trim().isEmpty()) {
                        relPrefix = this.prefixes.get(relId);
                        if (relPrefix == null) {
                            this.log.debug("rel_type is null!" + relId);
                            continue;
                        }
                        if (relPrefix.equals("+")) {
                            phenoId = relId;
                            phenoPrefix = relPrefix;
                        }
                    } else if (relId.equals("") && phenoId != null) {
                        phenoPrefix = this.prefixes.get(phenoId);
                        if (phenoPrefix == null) {
                            this.log.debug("pheno_type is null!" + relId);
                            continue;
                        }
                        if (phenoPrefix.equals("+")) {
                            relId = phenoId;
                            relPrefix = phenoPrefix;
                        }
                    }
                    if (phenoId == null && "%".equals(relPrefix)) {
                        if (!this.loci.containsKey(relId)) {
                            this.loci.put(phenoId, new HashSet());
                        }
                        this.loci.get(relId).add(locus);
                        continue;
                    }
                    if (relId.equals("") || phenoId == null) {
                        this.log.debug("pheno_id or rel_id is null");
                        continue;
                    }
                    phenoPrefix = phenoPrefix != null ? phenoPrefix : this.prefixes.get(phenoId);
                    String string = relPrefix = relPrefix != null ? relPrefix : this.prefixes.get(relId);
                    if (phenoPrefix == null || relPrefix == null) {
                        this.log.debug("pheno_type or rel_type is null");
                        continue;
                    }
                    if (phenoPrefix.equals("*") || relPrefix.equals("#") || relPrefix.equals("%") || phenoPrefix.equals("+") && relPrefix.equals("+") && !phenoId.equals(relId)) {
                        this.log.info("Strange combination of omim_id prefixes found in morbismap: pheno '" + phenoPrefix + phenoId + "', geno '" + relPrefix + relId + "'");
                        continue;
                    }
                    if (!this.loci.containsKey(phenoId)) {
                        this.loci.put(phenoId, new HashSet());
                    }
                    if (!this.rels.containsKey(phenoId)) {
                        this.rels.put(phenoId, new HashSet());
                    }
                    this.loci.get(phenoId).add(locus);
                    this.rels.get(phenoId).add(relId);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.log.error("", e);
        }
    }

    @Override
    public UpdatePlugin.UpdateType getType() {
        return UpdatePlugin.UpdateType.META_DATA;
    }

    @Override
    protected int getCurrentUpdateHash() throws Exception {
        return this.computeHashCodeFromOnlineFiles(Arrays.asList(this.urlMoridMap, this.urlOmim));
    }
}

