/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update.plugin;

import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.update.AbstractUpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePlugin;
import de.berlin.hu.ppi.wrapper.ProteinInteraction;
import de.berlin.hu.ppi.wrapper.StaxWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;

public final class MipsUpdatePlugin
extends AbstractUpdatePlugin
implements PpiConstants {
    private static final int DOWNLOADING = 0;
    private static final int COUNTING_INTERACTIONS = 1;
    private static final int LOADING_INTERACTIONS = 2;
    private static Logger log = Logger.getLogger(MipsUpdatePlugin.class);
    private static UpdatePlugin instance;
    private File target;
    private static final String URL = "http://mips.gsf.de/proj/ppi/data/mppi.gz";

    private MipsUpdatePlugin() throws Exception {
        this.sourceId = PpiConstants.DB_ID.MIPS;
        this.taskCount = 3;
        this.taskDescriptions = new String[]{"Downloading", "Counting interactions.", "Loading MIPS data."};
        this.pluginName = "Mammalian Protein-Protein Interaction Database (MIPS)";
        this.description = "This plugin updates the PPI-data from '" + this.pluginName + "'.";
        log = Logger.getLogger(MipsUpdatePlugin.class);
        this.checkForUpdates();
    }

    @Override
    protected Iterable<ProteinInteraction> getInteractionSource() {
        if (this.target != null) {
            try {
                GZIPInputStream in = new GZIPInputStream(new FileInputStream(this.target));
                return new StaxWrapper(in, this.target.getAbsolutePath());
            }
            catch (FileNotFoundException e) {
                log.error("", e);
            }
            catch (IOException e) {
                log.error("", e);
            }
        }
        return null;
    }

    public static UpdatePlugin getInstance() throws Exception {
        if (instance == null) {
            instance = new MipsUpdatePlugin();
        }
        return instance;
    }

    @Override
    public void runUpdate() throws SQLException {
        if (!this.isInterrupted) {
            this.startTask(0);
            this.target = this.download(URL);
        }
        int counted = 0;
        if (!this.isInterrupted) {
            this.startTask(1);
            counted = this.countingInteractions();
        }
        if (!this.isInterrupted) {
            this.startTask(2);
            this.loadingInteractions(counted);
        }
    }

    @Override
    protected int getCurrentUpdateHash() throws Exception {
        return this.computeHashCodeFromOnlineFiles(Arrays.asList(URL));
    }
}

