/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update.plugin;

import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.update.AbstractUpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePlugin;
import de.berlin.hu.ppi.wrapper.MultipleWrapper;
import de.berlin.hu.ppi.wrapper.ProteinInteraction;
import de.berlin.hu.ppi.wrapper.ZipInteractionIterator;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.zip.ZipException;
import org.apache.log4j.Logger;

public final class MintUpdatePlugin
extends AbstractUpdatePlugin
implements PpiConstants {
    private static final int DOWNLOADING = 0;
    private static final int COUNTING_INTERACTIONS = 1;
    private static final int LOADING_INTERACTIONS = 2;
    private static Logger log = Logger.getLogger(MintUpdatePlugin.class);
    private static UpdatePlugin instance;
    private File downloadedFile;
    private String url = "ftp://mint.bio.uniroma2.it/pub/release/psi/current/psi25/dataset/full.psi25.zip";

    private MintUpdatePlugin() throws Exception {
        this.sourceId = PpiConstants.DB_ID.MINT;
        this.taskCount = 3;
        this.taskDescriptions = new String[]{"Downloading", "Counting interactions.", "Loading MINT data."};
        this.pluginName = "Molecular INTeraction database (MINT)";
        this.description = "This plugin updates the PPI-data from '" + this.pluginName + "'.";
        this.checkForUpdates();
    }

    public static UpdatePlugin getInstance() throws Exception {
        if (instance == null) {
            instance = new MintUpdatePlugin();
        }
        return instance;
    }

    @Override
    public void runUpdate() throws SQLException {
        if (!this.isInterrupted) {
            this.startTask(0);
            this.downloadedFile = this.download(this.url);
        }
        int counted = 0;
        if (!this.isInterrupted) {
            this.startTask(1);
            counted = this.countingInteractions();
        }
        if (!this.isInterrupted) {
            this.startTask(2);
            this.loadingInteractions(counted);
        }
    }

    @Override
    protected Iterable<ProteinInteraction> getInteractionSource() {
        try {
            return new MultipleWrapper(ZipInteractionIterator.getZipInteractionIterator(this.downloadedFile));
        }
        catch (ZipException e) {
            log.error("", e);
        }
        catch (IOException e) {
            log.error("", e);
        }
        return super.getInteractionSource();
    }

    @Override
    protected int getCurrentUpdateHash() throws Exception {
        return this.computeHashCodeFromOnlineFiles(Arrays.asList(this.url));
    }
}

