/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update.plugin;

import de.berlin.hu.ppi.update.AbstractUpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePlugin;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.GetMethod;

public class MapLocationPlugin
extends AbstractUpdatePlugin {
    public static final String COLLECT_GENE_IDS = "select molecule_id, id from reference where db = 'gene_id'";
    public static final String INSERT_MAP_LOCATION = "insert into chromosomal_location values (?, ?)";
    public static final String DELETE_MAP_LOCATION = "delete from chromosomal_location";
    public static final String QUERY_URL = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?db=gene&id=%s&retmode=text";
    private static UpdatePlugin instance;
    private HttpClient client;
    private List<Integer> geneIdsList;
    private HashMap<Integer, String> geneIdToMapLocation;
    private int count;
    private String descriptionFormat;
    private int dataCount;

    private MapLocationPlugin() throws Exception {
        this.pluginName = "Map Location";
        this.description = "This plugin updates the map locations of the genes of proteins.";
        this.taskCount = 2;
        this.client = new HttpClient();
    }

    public static UpdatePlugin getInstance() throws Exception {
        if (instance == null) {
            instance = new MapLocationPlugin();
        }
        return instance;
    }

    @Override
    protected void runUpdate() throws Exception {
        if (this.isInterrupted) {
            return;
        }
        Connection con = this.openDatabaseConnection();
        con.setAutoCommit(false);
        Statement stat = con.createStatement();
        ResultSet result = stat.executeQuery(COLLECT_GENE_IDS);
        HashMap<Integer, Integer> moleculeIdToGeneId = new HashMap<Integer, Integer>();
        this.dataCount = 0;
        while (result.next()) {
            ++this.dataCount;
        }
        int[] geneIds = new int[this.dataCount];
        this.geneIdsList = new ArrayList<Integer>(this.dataCount);
        int i = 0;
        result.beforeFirst();
        while (result.next() && !this.isInterrupted) {
            int moleculeId = result.getInt(1);
            int geneId = Integer.parseInt(result.getString(2));
            moleculeIdToGeneId.put(moleculeId, geneId);
            geneIds[i] = geneId;
            this.geneIdsList.add(geneId);
            ++i;
        }
        if (this.isInterrupted) {
            return;
        }
        this.startNextTask("Retrieving map locations");
        this.setCounterFinish(this.dataCount);
        this.geneIdToMapLocation = new HashMap();
        this.descriptionFormat = "Retrieving map locations (%d/%d)";
        this.count = 0;
        int threadCount = 10;
        Thread worker = null;
        final Semaphore sem = new Semaphore(threadCount, true);
        for (int j = 0; j < threadCount; ++j) {
            worker = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (!MapLocationPlugin.this.geneIdsList.isEmpty() && !MapLocationPlugin.this.isInterrupted) {
                        int geneId;
                        try {
                            sem.acquire();
                        }
                        catch (InterruptedException e1) {
                            MapLocationPlugin.this.log.error("", e1);
                        }
                        List list = MapLocationPlugin.this.geneIdsList;
                        synchronized (list) {
                            geneId = (Integer)MapLocationPlugin.this.geneIdsList.remove(MapLocationPlugin.this.geneIdsList.size() - 1);
                        }
                        try {
                            String mapLocation = MapLocationPlugin.this.getMapLocation(geneId);
                            MapLocationPlugin.this.geneIdToMapLocation.put(geneId, mapLocation);
                            MapLocationPlugin.this.setTaskDescription(String.format(MapLocationPlugin.this.descriptionFormat, MapLocationPlugin.this.count++, MapLocationPlugin.this.dataCount));
                            MapLocationPlugin.this.incrementCounter();
                        }
                        catch (Exception e) {
                            MapLocationPlugin.this.log.info("Could not retrieve map location for geneId " + geneId);
                        }
                        sem.release();
                    }
                }
            };
            worker.start();
        }
        worker.join();
        if (this.isInterrupted) {
            return;
        }
        this.startNextTask("Inserting map locations");
        stat.executeUpdate(DELETE_MAP_LOCATION);
        PreparedStatement insertStatement = con.prepareStatement(INSERT_MAP_LOCATION);
        this.setCounterFinish(moleculeIdToGeneId.keySet().size());
        for (Integer moleculeId : moleculeIdToGeneId.keySet()) {
            if (this.isInterrupted) break;
            insertStatement.setInt(1, moleculeId);
            String mapLocation = this.geneIdToMapLocation.get(moleculeIdToGeneId.get(moleculeId));
            if (mapLocation != null && !mapLocation.trim().isEmpty()) {
                insertStatement.setString(2, mapLocation);
                insertStatement.execute();
            }
            this.incrementCounter();
        }
    }

    @Override
    protected int getCurrentUpdateHash() throws Exception {
        return -1;
    }

    @Override
    public UpdatePlugin.UpdateType getType() {
        return UpdatePlugin.UpdateType.META_DATA;
    }

    public String getMapLocation(int geneId) throws IOException {
        String urlString = String.format(QUERY_URL, geneId);
        URL url = new URL(urlString);
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        String line = reader.readLine();
        while (line != null && !this.isInterrupted) {
            if (line.contains("maploc")) {
                String[] splitted = line.split("maploc \"|\".*");
                String mapLocation = splitted[splitted.length - 1];
                return mapLocation;
            }
            line = reader.readLine();
        }
        this.log.info("Could not retrieve mapLocation for " + geneId + "\n\tURL: " + urlString);
        return null;
    }

    public String concat(int[] geneId, int offset, int length) {
        StringBuilder b = new StringBuilder();
        int lastIndex = Math.min(geneId.length, offset + length) - 1;
        for (int i = offset; i < lastIndex; ++i) {
            b.append(geneId[i]).append(',');
        }
        b.append(geneId[lastIndex]);
        return b.toString();
    }

    public Map<Integer, String> getMapLocation(int[] geneId, int offset, int length) throws IOException {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        String urlString = String.format(QUERY_URL, this.concat(geneId, offset, length));
        URL url = new URL(urlString);
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        String line = reader.readLine();
        int currentGeneId = 0;
        int index = 0;
        while (line != null && offset + index < geneId.length && !this.isInterrupted) {
            if (line.contains(String.valueOf(geneId[offset + index]))) {
                currentGeneId = geneId[offset + index];
            }
            if (line.contains("maploc")) {
                String[] splitted = line.split("maploc \"|\".*");
                String mapLocation = splitted[splitted.length - 1];
                result.put(currentGeneId, mapLocation);
                ++index;
                this.incrementCounter();
                break;
            }
            line = reader.readLine();
        }
        reader.close();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, String> getMapLocationHttpClient(int[] geneId, int offset, int length) throws IOException {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        String urlString = String.format(QUERY_URL, this.concat(geneId, offset, length));
        GetMethod method = new GetMethod(urlString);
        try {
            int statusCode = this.client.executeMethod(method);
            if (statusCode == 200) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream()));
                String line = reader.readLine();
                int currentGeneId = 0;
                int index = 0;
                while (line != null && offset + index < geneId.length && !this.isInterrupted) {
                    if (line.contains(String.valueOf(geneId[offset + index]))) {
                        currentGeneId = geneId[offset + index];
                    }
                    if (line.contains("maploc")) {
                        String[] splitted = line.split("maploc \"|\".*");
                        String mapLocation = splitted[splitted.length - 1];
                        result.put(currentGeneId, mapLocation);
                        ++index;
                        this.incrementCounter();
                    }
                    line = reader.readLine();
                }
                reader.close();
                HashMap<Integer, String> hashMap = result;
                return hashMap;
            }
            this.log.warn("Http Status was " + statusCode);
        }
        catch (Exception e) {
            this.log.error("", e);
        }
        finally {
            method.releaseConnection();
        }
        return null;
    }

    public static void main(String ... args) throws Exception {
        MapLocationPlugin test = new MapLocationPlugin();
        int[] geneId = new int[]{9, 2, 3, 4, 5, 6, 7, 8, 132, 13251, 122, 222};
        Map<Integer, String> map = test.getMapLocationHttpClient(geneId, 0, 1);
        System.out.println(map);
        System.out.println(test.getMapLocation(9));
    }
}

