/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update.plugin;

import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.PpiToolkit;
import de.berlin.hu.ppi.mediator.ProteinLoader;
import de.berlin.hu.ppi.mediator.dbx.DBProtein;
import de.berlin.hu.ppi.update.AbstractUpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePlugin;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;
import java.util.zip.GZIPInputStream;

public class LexiGenesUpdatePlugin
extends AbstractUpdatePlugin
implements PpiConstants {
    private static LexiGenesUpdatePlugin instance;
    private static final String fetchUniprotIdsUrl = "http://www.uniprot.org/uniprot/?query=organism:%d+AND+reviewed:yes&format=list&compress=yes&format=list";

    public LexiGenesUpdatePlugin() throws Exception {
        this.description = "Fetches and loads all reviewed uniprot entries for mouse and human.";
        this.pluginName = "Lexi Genes";
        this.taskCount = 4;
        this.checkForUpdates();
    }

    @Override
    public UpdatePlugin.UpdateType getType() {
        return UpdatePlugin.UpdateType.META_DATA;
    }

    public static UpdatePlugin getInstance() throws Exception {
        if (instance == null) {
            instance = new LexiGenesUpdatePlugin();
        }
        return instance;
    }

    @Override
    protected int getCurrentUpdateHash() throws Exception {
        String urlHuman = String.format(fetchUniprotIdsUrl, 9606);
        String urlMouse = String.format(fetchUniprotIdsUrl, 10090);
        return this.computeHashCodeFromOnlineFiles(Arrays.asList(urlHuman, urlMouse));
    }

    @Override
    protected void runUpdate() throws Exception {
        String uid;
        this.startNextTask("Fetching humand UniprotIds");
        String urlHuman = String.format(fetchUniprotIdsUrl, 9606);
        File idsHuman = this.download(urlHuman);
        this.startNextTask("Fetching mouse UniprotIds");
        String urlMouse = String.format(fetchUniprotIdsUrl, 10090);
        File idsMouse = this.download(urlMouse);
        this.startNextTask("Counting ids");
        ArrayList<String> uniprotIds = new ArrayList<String>();
        Scanner scan = new Scanner(new GZIPInputStream(new FileInputStream(idsHuman)));
        while (scan.hasNext() && !this.isInterrupted) {
            uid = scan.next();
            uniprotIds.add(uid);
        }
        scan = new Scanner(new GZIPInputStream(new FileInputStream(idsMouse)));
        while (scan.hasNext() && !this.isInterrupted) {
            uid = scan.next();
            uniprotIds.add(uid);
        }
        this.startNextTask("Inserting data from Uniprot");
        this.setCounterFinish(uniprotIds.size());
        ProteinLoader proteinLoader = new ProteinLoader(this.openDatabaseConnection());
        for (String uid2 : uniprotIds) {
            DBProtein[] load;
            if (this.isInterrupted) break;
            for (DBProtein dbProtein : load = proteinLoader.load(uid2, null)) {
                dbProtein.insert();
            }
            this.setTaskDescription(String.format("Inserting data from Uniprot (%d/%d)", this.getCurrentCounter(), uniprotIds.size()));
            this.incrementCounter();
        }
    }

    public static void main(String[] args) throws Exception {
        PpiToolkit.setupEnvironment();
        LexiGenesUpdatePlugin test = new LexiGenesUpdatePlugin();
        test.runUpdate();
    }
}

