/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update.plugin;

import de.berlin.hu.ppi.kegg.KEGGLocator;
import de.berlin.hu.ppi.kegg.KEGGPortType;
import de.berlin.hu.ppi.update.AbstractUpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePluginException;
import de.berlin.hu.ppi.update.plugin.KeggPathway;
import java.rmi.RemoteException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Vector;
import javax.xml.rpc.ServiceException;

public final class KeggUpdatePluginOld
extends AbstractUpdatePlugin {
    private static final int RETRY_WAITING_TIME = 5000;
    private static final String SQL_INSERT_KEGG_REL = "INSERT INTO kegg_rel VALUES (?, ?)";
    private static final String SQL_INSERT_KEGG_PATHWAY = "INSERT IGNORE INTO kegg_pathway VALUES (?, ?, ?)";
    private static final String QUERY_KEGG_IDS = "select distinct id from reference where db = 'kegg_id'";
    private ResultSet resultKeggIds;
    private static UpdatePlugin instance;
    private static int remoteQueryCount;
    private Map<String, List<KeggPathway>> keggRel = new HashMap<String, List<KeggPathway>>();
    private Vector<String> keggIds;
    private int fetchedDatasets;
    private int countedDatasets;
    public static final int THREAD_COUNT = 20;

    private KeggUpdatePluginOld() throws Exception {
        this.taskCount = 2;
        this.pluginName = "Kegg";
        this.description = "This plugin updates the Kegg data.";
    }

    @Override
    public void cancel() throws UpdatePluginException {
        super.cancel();
        this.keggIds.clear();
    }

    @Override
    public void reset() throws UpdatePluginException {
        super.reset();
        this.fetchedDatasets = 0;
        this.countedDatasets = 0;
    }

    public static UpdatePlugin getInstance() throws Exception {
        if (instance == null) {
            instance = new KeggUpdatePluginOld();
        }
        return instance;
    }

    @Override
    public void runUpdate() throws SQLException, InterruptedException {
        this.setTaskDescription("Fetching KeggIds...");
        this.connection = this.openDatabaseConnection();
        this.connection.setAutoCommit(false);
        PreparedStatement statementKeggIds = this.connection.prepareStatement(QUERY_KEGG_IDS);
        this.resultKeggIds = statementKeggIds.executeQuery();
        this.keggIds = new Vector();
        while (this.resultKeggIds.next() && !this.isInterrupted) {
            this.keggIds.add(this.resultKeggIds.getString(1));
        }
        this.connection.close();
        if (this.isInterrupted) {
            return;
        }
        this.startNextTask("Retrieving data from KEGG");
        Thread runner = null;
        this.setCounterFinish(this.keggIds.size());
        this.countedDatasets = this.keggIds.size();
        ArrayList<1> runningThreads = new ArrayList<1>();
        for (int i = 0; i < 20 && !this.isInterrupted; ++i) {
            runner = new Thread(){

                @Override
                public void run() {
                    KeggUpdatePluginOld.this.performFetching();
                }
            };
            runner.start();
            runningThreads.add(runner);
        }
        for (Thread thread : runningThreads) {
            thread.join();
        }
        if (this.isInterrupted) {
            return;
        }
        this.startNextTask("Inserting datasets");
        this.connection = this.openDatabaseConnection();
        this.connection.setAutoCommit(false);
        this.clearTable("kegg_rel");
        this.clearTable("kegg_pathway");
        PreparedStatement insertKeggPathway = this.connection.prepareStatement(SQL_INSERT_KEGG_PATHWAY);
        PreparedStatement preparedStatement = this.connection.prepareStatement(SQL_INSERT_KEGG_REL);
        this.setCounterFinish(this.keggRel.keySet().size());
        for (String keggId : this.keggRel.keySet()) {
            if (this.isInterrupted) {
                return;
            }
            List<KeggPathway> pathways = this.keggRel.get(keggId);
            for (KeggPathway pathway : pathways) {
                if (this.isInterrupted) {
                    return;
                }
                insertKeggPathway.setString(1, pathway.getPathwayId());
                insertKeggPathway.setString(2, pathway.getName());
                insertKeggPathway.setString(3, pathway.getKeggClass());
                insertKeggPathway.execute();
                preparedStatement.setString(2, keggId);
                preparedStatement.setString(1, pathway.getPathwayId());
                preparedStatement.execute();
            }
            this.incrementCounter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performFetching() {
        this.log.trace(Thread.currentThread().getName() + " started.");
        try {
            KEGGPortType port = new KEGGLocator().getKEGGPort();
            while (!this.keggIds.isEmpty() && !this.isInterrupted) {
                String keggId = null;
                Vector<String> vector = this.keggIds;
                synchronized (vector) {
                    keggId = this.keggIds.remove(this.keggIds.size() - 1);
                }
                boolean done = false;
                do {
                    try {
                        List<KeggPathway> result;
                        if (keggId != null && !(result = this.getPathways(keggId, port)).isEmpty()) {
                            this.keggRel.put(keggId, result);
                        }
                        done = true;
                    }
                    catch (RemoteException e) {
                        this.log.info("Not working for " + keggId + " waiting some time. Remote query count: " + remoteQueryCount);
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e1) {
                            // empty catch block
                        }
                    }
                } while (!done);
                this.incrementCounter();
                this.setTaskDescription(String.format("Loading data (%d/%d)", this.fetchedDatasets++, this.countedDatasets));
            }
        }
        catch (ServiceException e) {
            this.log.error("", e);
        }
        this.log.trace(Thread.currentThread().getName() + " finished.");
    }

    public List<KeggPathway> getPathways(String keggId, KEGGPortType port) throws RemoteException {
        Vector<KeggPathway> keggPathways = new Vector<KeggPathway>();
        ++remoteQueryCount;
        String[] pathwayIds = port.get_pathways_by_genes(new String[]{keggId});
        --remoteQueryCount;
        for (String pathwayId : pathwayIds) {
            boolean done = false;
            while (!done) {
                try {
                    String result = port.bget(pathwayId);
                    Scanner resultScanner = new Scanner(result);
                    KeggPathway pathway = new KeggPathway();
                    pathway.setPathwayId(pathwayId);
                    while (resultScanner.hasNextLine()) {
                        String line = resultScanner.nextLine();
                        if (line.startsWith("NAME")) {
                            String name = new Scanner(line).skip("NAME( )*").nextLine();
                            pathway.setName(name);
                        }
                        if (!line.startsWith("CLASS")) continue;
                        String keggClass = new Scanner(line).skip("CLASS( )*").nextLine();
                        pathway.setKeggClass(keggClass);
                    }
                    keggPathways.add(pathway);
                    done = true;
                }
                catch (Exception e) {
                    this.log.warn("Kegg not working for " + pathwayId + ", waiting some time...");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {}
                }
            }
        }
        return keggPathways;
    }

    @Override
    public UpdatePlugin.UpdateType getType() {
        return UpdatePlugin.UpdateType.META_DATA;
    }

    @Override
    protected int getCurrentUpdateHash() throws Exception {
        return -1;
    }
}

