/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update.plugin;

import de.berlin.hu.ppi.kegg.KEGGLocator;
import de.berlin.hu.ppi.kegg.KEGGPortType;
import de.berlin.hu.ppi.update.AbstractUpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePluginException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.ServiceException;

public final class KeggUpdatePlugin
extends AbstractUpdatePlugin {
    private static final int RETRIEVING_DATASETS = 0;
    private static final int LOADING_DATASETS = 1;
    private static final int MAX_THREAD_COUNT = 100;
    private static final String KEGG_REL = "kegg_rel";
    private static final String KEGG_PATHWAY = "kegg_pathway";
    private static final String SQL_FETCH_KEGG_IDS = "select disinct id from reference where db = 'kegg_id'";
    private static final String SQL_INSERT_KEGG_PATHWAY = "INSERT INTO kegg_pathway VALUES (?, ?, ?)";
    private static final String SQL_INSERT_KEGG_REL = "INSERT INTO kegg_rel VALUES (?, ?)";
    private static final int MODE_OLD = 0;
    private static final int MODE_NEW = 1;
    private int countedDatasets;
    private Integer loadedDatasets;
    private static UpdatePlugin instance;
    public int mode = 0;
    private Map<String, Set<String>> keggPathwayMap;
    private Map<String, String[]> pathwayData;
    private ResultSet keggIds;
    private List<Thread> threads;

    private KeggUpdatePlugin() throws Exception {
        this.taskCount = 2;
        this.taskDescriptions = new String[]{"Retrieving data from KEGG.", "Loading data into database."};
        this.pluginName = "Kegg";
        this.description = "This plugin updates the Kegg data. KEGG PATHWAY is a collection of manually drawn pathway maps representing our knowledge on the molecular interaction and reaction networks.";
        this.checkForUpdates();
    }

    public static UpdatePlugin getInstance() throws Exception {
        if (instance == null) {
            instance = new KeggUpdatePlugin();
        }
        return instance;
    }

    @Override
    public void cancel() throws UpdatePluginException {
        if (!this.banCancel) {
            switch (this.getState()) {
                case RUNNING: {
                    this.log.info("try to interrupt main thread...");
                    this.isInterrupted = true;
                    for (Thread thread : this.threads) {
                        thread.interrupt();
                    }
                    super.cancel();
                }
            }
        }
        throw new UpdatePluginException("Update process cannot be interrupted at the moment.");
    }

    @Override
    public void reset() throws UpdatePluginException {
        super.reset();
        this.countedDatasets = 0;
        this.loadedDatasets = 0;
    }

    @Override
    public void runUpdate() {
        if (!this.isInterrupted) {
            this.startTask(0);
            this.retrieveDatasets();
        }
        if (!this.isInterrupted) {
            this.startTask(1);
            this.loadDatasets();
        }
    }

    private void loadDatasets() {
        try {
            PreparedStatement insertKeggRel = this.connection.prepareStatement(SQL_INSERT_KEGG_REL);
            this.clearTables(KEGG_REL, KEGG_PATHWAY);
            if (!this.isInterrupted) {
                this.setCounterFinish(this.keggPathwayMap.keySet().size() + this.pathwayData.keySet().size());
                int insertedKegg = 0;
                for (String kegg_id : this.keggPathwayMap.keySet()) {
                    if (this.isInterrupted) break;
                    this.incrementCounter();
                    for (String pathwayId : this.keggPathwayMap.get(kegg_id)) {
                        insertKeggRel.setString(1, pathwayId);
                        insertKeggRel.setString(2, kegg_id);
                        insertKeggRel.addBatch();
                        if (++insertedKegg <= this.getBatchSize()) continue;
                        insertKeggRel.executeBatch();
                    }
                }
            }
            PreparedStatement insertKeggPathway = this.connection.prepareStatement(SQL_INSERT_KEGG_PATHWAY);
            int insertedPathwaysCount = 0;
            for (String pathwayId : this.pathwayData.keySet()) {
                if (this.isInterrupted) break;
                this.incrementCounter();
                String[] dataSet = this.pathwayData.get(pathwayId);
                insertKeggPathway.setString(1, pathwayId);
                insertKeggPathway.setString(2, dataSet[0]);
                insertKeggPathway.setString(3, dataSet[1]);
                insertKeggPathway.addBatch();
                if (++insertedPathwaysCount <= this.getBatchSize()) continue;
                insertKeggPathway.executeBatch();
            }
            if (!this.isInterrupted) {
                insertKeggPathway.executeBatch();
                insertKeggRel.executeBatch();
            }
        }
        catch (SQLException e) {
            this.log.error("", e);
        }
    }

    private void retrieveDatasets() {
        try {
            this.setCounterFinish(100L);
            this.openDatabaseConnection();
            PreparedStatement findKeggIds = this.connection.prepareStatement(SQL_FETCH_KEGG_IDS);
            this.keggIds = findKeggIds.executeQuery();
            while (this.keggIds.next()) {
                ++this.countedDatasets;
            }
            this.keggIds.beforeFirst();
            this.setCounterFinish(this.countedDatasets);
            this.threads = null;
            if (!this.isInterrupted) {
                int threadCount = Math.min(100, this.countedDatasets);
                this.keggPathwayMap = new HashMap<String, Set<String>>();
                this.pathwayData = new HashMap<String, String[]>();
                this.threads = new ArrayList<Thread>(threadCount);
                this.loadedDatasets = 0;
                for (int i = 0; i < threadCount; ++i) {
                    Thread current = null;
                    switch (this.mode) {
                        case 0: {
                            current = new Thread((Runnable)new KeggLoader(), "Kegg-Loader " + i);
                            break;
                        }
                        case 1: {
                            current = new Thread((Runnable)new KeggLoader2(), "Kegg-Loader " + i);
                        }
                    }
                    current.start();
                    this.threads.add(current);
                }
            }
            for (Thread thread : this.threads) {
                try {
                    thread.join();
                }
                catch (InterruptedException e) {}
            }
        }
        catch (SQLException e1) {
            this.log.error("", e1);
        }
    }

    @Override
    public UpdatePlugin.UpdateType getType() {
        return UpdatePlugin.UpdateType.META_DATA;
    }

    public void getKeggPathways(List<String> keggIds) {
        try {
            String query = KeggUpdatePlugin.createKeggQuery(keggIds);
            URL url = new URL(query);
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = reader.readLine();
            String currentKeggId = null;
            String currentPathwayId = null;
            String split = "<input type=\"hidden\" name=\"KEGGID\" value=\"";
            while (line != null && !Thread.currentThread().isInterrupted()) {
                if (!line.isEmpty()) {
                    if (line.startsWith(split)) {
                        String[] splitted = line.split(split);
                        if (splitted.length > 1) {
                            String token = splitted[1];
                            currentKeggId = token.substring(0, token.length() - 3);
                            Integer n = this.loadedDatasets;
                            Integer n2 = this.loadedDatasets = Integer.valueOf(this.loadedDatasets + 1);
                            this.incrementCounter();
                        }
                    } else if (line.contains("PATH: ")) {
                        int index = line.indexOf("</a>");
                        currentPathwayId = line.substring(index - 8, index);
                        if (currentKeggId != null && !currentKeggId.isEmpty()) {
                            if (this.keggPathwayMap.get(currentKeggId) == null) {
                                this.keggPathwayMap.put(currentKeggId, new HashSet());
                            }
                            this.keggPathwayMap.get(currentKeggId).add(currentPathwayId);
                        }
                    }
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (MalformedURLException e) {
            this.log.error("", e);
        }
        catch (IOException e) {
            this.log.error("", e);
        }
    }

    public static String createKeggQuery(List<String> keggIds) {
        StringBuilder b = new StringBuilder();
        b.append("http://www.genome.jp/dbget-bin/www_bget?");
        for (int i = 0; i < keggIds.size() - 1; ++i) {
            b.append(keggIds.get(i));
            b.append('+');
        }
        b.append(keggIds.get(keggIds.size() - 1));
        return b.toString();
    }

    @Override
    protected int getCurrentUpdateHash() throws Exception {
        return -1;
    }

    private class KeggLoader
    implements Runnable {
        private KEGGPortType port;

        public KeggLoader() {
            try {
                this.port = new KEGGLocator().getKEGGPort();
            }
            catch (ServiceException e) {
                KeggUpdatePlugin.this.log.error("", e);
            }
        }

        private void getPathwaysByGene(String keggId) {
            try {
                String[] pathwayIds = this.port.get_pathways_by_genes(new String[]{keggId});
                for (int i = 0; i < pathwayIds.length && !Thread.currentThread().isInterrupted(); ++i) {
                    String pathwayId = pathwayIds[i];
                    String result = this.port.bget(pathwayId);
                    if (result.contains("NAME") && result.contains("CLASS")) {
                        String name = result.substring(result.indexOf("NAME") + 4, result.indexOf(" - ")).trim();
                        String kegg_class = result.substring(result.indexOf("CLASS") + 5, result.indexOf("PATHWAY")).trim();
                        String[] entryNew = new String[]{name, kegg_class};
                        KeggUpdatePlugin.this.pathwayData.put(pathwayId, entryNew);
                    }
                    if (KeggUpdatePlugin.this.keggPathwayMap.get(keggId) == null) {
                        KeggUpdatePlugin.this.keggPathwayMap.put(keggId, new HashSet());
                    }
                    ((Set)KeggUpdatePlugin.this.keggPathwayMap.get(keggId)).add(pathwayId);
                }
            }
            catch (RemoteException e) {
                KeggUpdatePlugin.this.log.error("", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                String keggId = null;
                Object object = KeggUpdatePlugin.this.keggIds;
                synchronized (object) {
                    try {
                        if (!KeggUpdatePlugin.this.keggIds.next()) {
                            KeggUpdatePlugin.this.log.info(Thread.currentThread().getName() + " is done.");
                            return;
                        }
                        keggId = KeggUpdatePlugin.this.keggIds.getString(1);
                    }
                    catch (SQLException e) {
                        KeggUpdatePlugin.this.log.error("", e);
                    }
                }
                if (keggId != null) {
                    this.getPathwaysByGene(keggId);
                    object = KeggUpdatePlugin.this.loadedDatasets;
                    synchronized (object) {
                        Integer n = KeggUpdatePlugin.this.loadedDatasets;
                        Integer n2 = KeggUpdatePlugin.this.loadedDatasets = KeggUpdatePlugin.this.loadedDatasets + 1;
                    }
                    ((KeggUpdatePlugin)KeggUpdatePlugin.this).taskDescriptions[KeggUpdatePlugin.this.getCurrentTaskId()] = "Loading Datasets. (" + KeggUpdatePlugin.this.loadedDatasets + "/" + KeggUpdatePlugin.this.countedDatasets + ")";
                    KeggUpdatePlugin.this.incrementCounter();
                }
                Thread.yield();
            }
            KeggUpdatePlugin.this.log.info(Thread.currentThread() + " was interrupted successfully.");
        }
    }

    private class KeggLoader2
    implements Runnable {
        private KeggLoader2() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (KeggUpdatePlugin.this.loadedDatasets < KeggUpdatePlugin.this.countedDatasets && !Thread.currentThread().isInterrupted()) {
                int idsPerQuery = Math.min(KeggUpdatePlugin.this.countedDatasets - KeggUpdatePlugin.this.loadedDatasets, 50);
                ArrayList<String> ids = new ArrayList<String>(idsPerQuery);
                ResultSet resultSet = KeggUpdatePlugin.this.keggIds;
                synchronized (resultSet) {
                    for (int i = 0; i < idsPerQuery; ++i) {
                        try {
                            if (!KeggUpdatePlugin.this.keggIds.next()) continue;
                            ids.add(KeggUpdatePlugin.this.keggIds.getString(1));
                            continue;
                        }
                        catch (SQLException e) {
                            KeggUpdatePlugin.this.log.error("", e);
                        }
                    }
                }
                KeggUpdatePlugin.this.getKeggPathways(ids);
            }
            if (Thread.currentThread().isInterrupted()) {
                KeggUpdatePlugin.this.log.info(Thread.currentThread() + " was interrupted successfully.");
            }
        }
    }
}

