/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update.plugin;

import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.parser.KeggParser;
import de.berlin.hu.ppi.parser.object.Graph;
import de.berlin.hu.ppi.tool.FileTool;
import de.berlin.hu.ppi.tool.ProgressCounter;
import de.berlin.hu.ppi.update.AbstractPathwayUpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePlugin;
import de.berlin.hu.ppi.update.plugin.StorePathwaysInDB;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.log4j.Logger;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;

public class KeggPathwayUpdatePlugin
extends AbstractPathwayUpdatePlugin {
    private static UpdatePlugin instance = null;
    private static final String FTP_URL = "ftp.genome.jp";
    private static final String FTP_FILE = "kgml.tar.gz";
    private static final String FTP_DIRECTORY = "pub/kegg/release/current/";
    public static final String FTP_FILE_LOCATION = "ftp://ftp.genome.jp/pub/kegg/release/current/kgml.tar.gz";
    private static final String TAR_GZ_DIRECTORY_METABOLISM = "kgml/metabolic";
    private static final String TAR_GZ_DIRECTORY_NON_METABOLISM = "kgml/non-metabolic";
    private Map<String, String> organisms;

    private KeggPathwayUpdatePlugin() throws Exception {
        this.uniquePathwayId = 0;
        this.pluginName = "KEGG Pathways";
        this.description = "This plugin updates the Kegg data. KEGG PATHWAY is a collection of manually drawn pathway maps representing our knowledge on the molecular interaction and reaction networks.";
        this.organisms = new HashMap<String, String>();
        this.organisms.put("ath", "Arabidopsis thaliana");
        this.organisms.put("cel", "Caenorhabditis elegans");
        this.organisms.put("dme", "Drosophila melanogaster");
        this.organisms.put("dre", "Danio rerio");
        this.organisms.put("eco", "Escherichia coli");
        this.organisms.put("gga", "Gallus gallus");
        this.organisms.put("hsa", "Homo sapiens");
        this.organisms.put("ko", null);
        this.organisms.put("mmu", "Mus musculus");
        this.organisms.put("ptr", "Pan troglodytes");
        this.organisms.put("rno", "Rattus norvegicus");
        this.organisms.put("spo", "Schizosaccharomyces pombe");
        this.organisms.put("xla", "Xenopus laevis");
        this.checkForUpdates();
    }

    public static UpdatePlugin getInstance() throws Exception {
        if (instance == null) {
            instance = new KeggPathwayUpdatePlugin();
        }
        return instance;
    }

    @Override
    protected void runUpdate() throws Exception {
        File dir = this.setTargetDirectoryToTmpWithSubfolder();
        if (this.isInterrupted) {
            return;
        }
        this.startNextTask();
        this.setTargetDirectory(dir);
        this.target = this.downloadViaWget(FTP_FILE_LOCATION);
        if (this.isInterrupted) {
            return;
        }
        this.extract();
        this.db = StorePathwaysInDB.getInstance();
        this.db.establishConnection();
        this.db.deleteDataFromTables(PpiConstants.DB_ID.KEGG);
        this.db.addSourceToDB(PpiConstants.DB_ID.KEGG);
        this.db.closeConnection();
        dir = FileTool.asDirectory(this.target);
        this.startNextTask();
        this.setCounterFinish(FileTool.listAllFiles(dir).size());
        for (String path : Arrays.asList(TAR_GZ_DIRECTORY_METABOLISM, TAR_GZ_DIRECTORY_NON_METABOLISM)) {
            File newdir = new File(dir.getAbsolutePath() + "/" + path);
            if (!newdir.exists()) continue;
            for (File subdir : newdir.listFiles()) {
                if ("ko".equals(subdir.getName())) {
                    this.processDirectory(subdir);
                    continue;
                }
                for (File file : subdir.listFiles()) {
                    if (!file.isDirectory()) continue;
                    this.processDirectory(file);
                }
            }
        }
        this.dateFetched.await();
        this.setUpdateTime("latestUpdate", this.updateDate);
    }

    private void processDirectory(File dir) throws Exception {
        for (File file : dir.listFiles()) {
            if (this.isInterrupted) {
                return;
            }
            if (!file.getName().endsWith(".xml")) continue;
            this.setTaskDescription("Parsing " + file.getName());
            KeggParser parser = new KeggParser(false, ProgressCounter.PATHWAY_PLUGIN_ID.KEGG);
            this.log.info("KeggPathwayUpdatePlugin: parsing pathway described in:\n\t\t" + file.getAbsolutePath());
            parser.generatePathway(new FileReader(file.getAbsolutePath()));
            Graph pathway = parser.getPathway();
            pathway.setOrganism(this.organisms.get(dir.getName()));
            pathway.setLastUpdate(new Date(file.lastModified()));
            this.setTaskDescription("Loading " + file.getName());
            this.loadIntoDb(pathway);
            this.incrementCounter();
        }
    }

    @Override
    protected Date getUpdateDate() {
        FTPClient ftp = new FTPClient();
        try {
            ftp.connect(FTP_URL);
            ftp.login("anonymous", "email@aol.com");
            ftp.enterLocalPassiveMode();
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion(reply)) {
                ftp.disconnect();
                System.err.println("FTP server refused connection.");
                return null;
            }
            ftp.changeWorkingDirectory(FTP_DIRECTORY);
            FTPFile[] file = ftp.listFiles(FTP_FILE);
            if (file.length != 0) {
                return file[0].getTimestamp().getTime();
            }
            Logger.getLogger(this.getClass()).error("File could not be found", new RuntimeException());
            return null;
        }
        catch (SocketException e) {
            this.log.error("", e);
        }
        catch (IOException e) {
            this.log.error("", e);
        }
        return null;
    }

    private int extract() throws IOException {
        String output = "Counting tar entries (%d)";
        this.setTaskDescription(String.format(output, 0));
        if (this.isInterrupted) {
            return -1;
        }
        TarInputStream tin = new TarInputStream(new GZIPInputStream(new FileInputStream(this.target)));
        int entryCount = 0;
        while (tin.getNextEntry() != null && !this.isInterrupted) {
            this.setTaskDescription(String.format(output, ++entryCount));
        }
        tin.close();
        this.log.info(String.format("%d Tar entries found.", entryCount));
        this.startNextTask();
        this.setCounterFinish(entryCount);
        File extractionPath = FileTool.asDirectory(this.target);
        if (extractionPath.exists()) {
            FileTool.deleteDirectoryRecursive(extractionPath);
        }
        extractionPath.mkdirs();
        this.setTaskDescription("Extracting files.");
        tin = new TarInputStream(new GZIPInputStream(new FileInputStream(this.target)));
        TarEntry tarEntry = tin.getNextEntry();
        while (tarEntry != null && !this.isInterrupted) {
            String fileName = tarEntry.getName();
            File file = new File(extractionPath.getAbsolutePath() + File.separatorChar + fileName);
            String organism = file.getParentFile().getName();
            if (this.organisms.containsKey(organism)) {
                file.getParentFile().mkdirs();
                if (file.createNewFile()) {
                    FileOutputStream out = new FileOutputStream(file);
                    this.setTaskDescription("Extracting: " + file.getName());
                    tin.copyEntryContents(out);
                    out.close();
                } else {
                    this.log.error("", new IOException("Could not create file " + file.getAbsolutePath()));
                }
            }
            this.incrementCounter();
            tarEntry = tin.getNextEntry();
        }
        tin.close();
        return entryCount;
    }

    private void loadIntoDb(Graph pathway) throws Exception {
        this.db.establishConnection();
        this.log.info("Inserting pathways into database.");
        try {
            this.db.loadPathwayIntoDb(pathway, this.uniquePathwayId++, pathway.getLastUpdate(), PpiConstants.DB_ID.KEGG);
        }
        catch (Exception e) {
            this.log.error("Could not load Pathway", e);
        }
        this.db.closeConnection();
        this.db.storeNewTaxonIds();
    }
}

