/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update.plugin;

import de.berlin.hu.ppi.update.AbstractUpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;

public final class InterproUpdatePlugin
extends AbstractUpdatePlugin {
    private static final String INTERPRO = "interpro";
    private static final int DOWNLOADING = 0;
    private static final int COUNTING_DATASETS = 1;
    private static final int LOADING_DATASETS = 2;
    private int countedDatasets = 0;
    private File target;
    private static UpdatePlugin instance;
    String url = "ftp://ftp.ebi.ac.uk/pub/databases/interpro/interpro.xml.gz";

    private InterproUpdatePlugin() throws Exception {
        this.taskCount = 3;
        this.taskDescriptions = new String[]{"Downloading ...", "Counting data sets...", "Loading data into database..."};
        this.pluginName = "Interpro";
        this.description = "This plugin updates the Interpro data. InterPro is a database of protein families, domains, regions, repeats and sites in which identifiable features found in known proteins can be applied to new protein sequences.";
        this.checkForUpdates();
    }

    public static UpdatePlugin getInstance() throws Exception {
        if (instance == null) {
            instance = new InterproUpdatePlugin();
        }
        return instance;
    }

    @Override
    public void runUpdate() throws SQLException {
        if (!this.isInterrupted) {
            this.startTask(0);
            this.setTargetDirectoryToTmp();
            this.openDatabaseConnection();
            this.connection.setAutoCommit(false);
            this.target = this.download(this.url);
        }
        if (!this.isInterrupted) {
            this.startTask(1);
            this.countingDatasets();
        }
        if (!this.isInterrupted) {
            this.startTask(2);
            this.loadingDatasets();
        }
    }

    private void loadingDatasets() {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(this.target))));
            this.clearTables(INTERPRO);
            PreparedStatement insertStmt = this.connection.prepareStatement("INSERT INTO interpro VALUES (?,?)");
            boolean state = false;
            String ip_id = "";
            int insertedDatasets = 0;
            this.setCounterFinish(this.countedDatasets);
            while ((line = reader.readLine()) != null && !this.isInterrupted) {
                if (state) {
                    if (line.matches("\\s*<name>.*</name>\\s*")) {
                        String name = line.split(">")[1].split("<")[0];
                        insertStmt.setString(1, ip_id);
                        insertStmt.setString(2, name);
                        insertStmt.addBatch();
                        this.incrementCounter();
                        if (++insertedDatasets % this.getBatchSize() == 0) {
                            insertStmt.executeBatch();
                        }
                        state = false;
                        continue;
                    }
                    if (!line.matches("\\s*<interpro\\s+id=.*")) continue;
                    ip_id = line.split("\"")[1];
                    continue;
                }
                if (!line.matches("\\s*<interpro\\s+id=.*")) continue;
                ip_id = line.split("\"")[1];
                state = true;
            }
            if (this.isInterrupted) {
                return;
            }
            insertStmt.executeBatch();
        }
        catch (Exception e) {
            this.log.error(e);
            System.exit(0);
        }
    }

    @Override
    protected void finish() {
        this.banCancel = true;
        try {
            PreparedStatement statement = this.connection.prepareStatement("DELETE FROM interpro_rel WHERE interpro_id NOT IN (SELECT interpro_id FROM interpro)");
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.log.error("", e);
        }
        this.banCancel = false;
        super.finish();
    }

    private void countingDatasets() {
        try {
            String line;
            this.reader = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(this.target))));
            try {
                this.setCounterFinish(Integer.parseInt(this.getProperty("dataCount")));
            }
            catch (Exception e) {
                this.log.warn("No Value for 'dataCount' found, used standard one.");
                this.setCounterFinish(20000L);
            }
            this.countedDatasets = 0;
            while ((line = this.reader.readLine()) != null && !this.isInterrupted) {
                if (!line.matches("\\s*<interpro\\s+id=.+")) continue;
                ++this.countedDatasets;
                this.incrementCounter();
            }
            this.reader.close();
        }
        catch (IOException e) {
            this.log.error(e);
            System.exit(0);
        }
        if (!this.isInterrupted) {
            this.setProperty("dataCount", Integer.toString(this.countedDatasets));
        }
    }

    @Override
    public UpdatePlugin.UpdateType getType() {
        return UpdatePlugin.UpdateType.META_DATA;
    }

    @Override
    protected int getCurrentUpdateHash() throws Exception {
        return this.computeHashCodeFromOnlineFiles(Arrays.asList(this.url));
    }
}

