/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update.plugin;

import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.update.AbstractUpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePlugin;
import de.berlin.hu.ppi.wrapper.MultipleWrapper;
import de.berlin.hu.ppi.wrapper.ProteinInteraction;
import de.berlin.hu.ppi.wrapper.ZipInteractionIterator;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.zip.ZipException;

public final class IntActUpdatePlugin
extends AbstractUpdatePlugin
implements PpiConstants {
    private static final int DOWNLOADING = 0;
    private static final int COUNTING_INTERACTIONS = 1;
    private static final int LOADING_INTERACTIONS = 2;
    private static UpdatePlugin instance;
    private File downloadedFile;
    String url = "ftp://ftp.ebi.ac.uk/pub/databases/intact/current/psi25/pmidMIF25.zip";

    private IntActUpdatePlugin() throws Exception {
        this.sourceId = PpiConstants.DB_ID.INTACT;
        this.taskCount = 3;
        this.taskDescriptions = new String[]{"Downloading", "Counting interactions.", "Loading Intact data."};
        this.pluginName = "IntAct";
        this.description = "This plugin updates the PPI-data from '" + this.pluginName + "'.";
        this.checkForUpdates();
    }

    public static UpdatePlugin getInstance() throws Exception {
        if (instance == null) {
            instance = new IntActUpdatePlugin();
        }
        return instance;
    }

    @Override
    public void runUpdate() throws SQLException {
        if (!this.isInterrupted) {
            this.startTask(0);
            this.downloadedFile = this.download(this.url);
        }
        int counted = 0;
        if (!this.isInterrupted) {
            this.startTask(1);
            counted = this.countingInteractions();
        }
        if (!this.isInterrupted) {
            this.startTask(2);
            this.loadingInteractions(counted);
        }
    }

    @Override
    protected int getCurrentUpdateHash() throws Exception {
        return this.computeHashCodeFromOnlineFiles(Arrays.asList(this.url));
    }

    @Override
    protected Iterable<ProteinInteraction> getInteractionSource() {
        try {
            this.log.trace("Adding '" + this.downloadedFile.getAbsolutePath() + "' to interaction source");
            return new MultipleWrapper(ZipInteractionIterator.getZipInteractionIterator(this.downloadedFile));
        }
        catch (ZipException e) {
            this.log.error("", e);
        }
        catch (IOException e) {
            this.log.error("", e);
        }
        return null;
    }
}

