/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update.plugin;

import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.update.AbstractUpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePlugin;
import de.berlin.hu.ppi.wrapper.MultipleWrapper;
import de.berlin.hu.ppi.wrapper.ProteinInteraction;
import de.berlin.hu.ppi.wrapper.ZipInteractionIterator;
import de.berlin.hu.wbi.common.collection.Lists;
import de.berlin.hu.wbi.common.filter.MatcherFilter;
import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPListParseEngine;

public final class IntActDiseaseUpdatePlugin
extends AbstractUpdatePlugin
implements PpiConstants {
    private static final int COUNTING_INTERACTIONS = 2;
    private static final int LOADING_INTERACTIONS = 3;
    private static UpdatePlugin instance;
    private List<File> downloadedFiles;
    private MatcherFilter zipFilter = new MatcherFilter(".*[.]zip");
    private List<String> paths = Arrays.asList("ftp://ftp.ebi.ac.uk/pub/databases/intact/current/psi25/datasets/datasets/Cancer/", "ftp://ftp.ebi.ac.uk/pub/databases/intact/current/psi25/datasets/datasets/Alzheimers/");

    private IntActDiseaseUpdatePlugin() throws Exception {
        this.sourceId = PpiConstants.DB_ID.INTACT_DISEASE;
        this.taskCount = 4;
        this.taskDescriptions = new String[]{"Downloading", "Downloading", "Counting Intact disease interactions.", "Loading Intact disease data."};
        this.pluginName = "IntActDisease";
        this.description = "This plugin updates the PPI-data from '" + this.pluginName + "'.";
        this.downloadedFiles = new ArrayList<File>();
        this.checkForUpdates();
    }

    public static UpdatePlugin getInstance() throws Exception {
        if (instance == null) {
            instance = new IntActDiseaseUpdatePlugin();
        }
        return instance;
    }

    @Override
    public void runUpdate() throws Exception {
        this.downloadedFiles.clear();
        this.setTaskDescription("Collecting URLs...");
        List<String> urls = this.getUrls();
        this.taskCount = 3;
        this.setCounterFinish(urls.size());
        this.startNextTask();
        StringBuilder sb = new StringBuilder();
        for (String url : urls) {
            sb.setLength(0);
            sb.append(url);
            this.taskDescription = "Downloading: " + IntActDiseaseUpdatePlugin.shortenUrl(sb, 45);
            if (this.isInterrupted) break;
            File file = null;
            try {
                file = this.downloadViaFtpClient(url, false);
            }
            catch (Exception e) {
                this.log.warn("Could not download: " + url, e);
            }
            if (file != null && file.exists()) {
                this.downloadedFiles.add(file);
            }
            this.incrementCounter();
        }
        int counted = 0;
        if (!this.isInterrupted) {
            this.startTask(2);
            counted = this.countingInteractions();
        }
        if (!this.isInterrupted) {
            this.startTask(3);
            this.loadingInteractions(counted);
        }
    }

    private List<String> getUrls() throws Exception {
        Exception e = null;
        ArrayList<String> output = new ArrayList<String>();
        for (String path : this.paths) {
            try {
                List<Object> files = IntActDiseaseUpdatePlugin.listFilesFromFtp(path);
                files = Lists.filter(files, this.zipFilter);
                output.addAll(files);
            }
            catch (Exception e2) {
                e = e2;
                this.log.warn("", e);
            }
        }
        if (output.size() == 0 && e != null) {
            throw e;
        }
        return output;
    }

    @Override
    protected Iterable<ProteinInteraction> getInteractionSource() {
        ArrayList<Iterable<ProteinInteraction>> multiple = new ArrayList<Iterable<ProteinInteraction>>();
        for (File file : this.downloadedFiles) {
            try {
                multiple.add(new MultipleWrapper(ZipInteractionIterator.getZipInteractionIterator(file)));
                this.log.trace("Adding '" + file.getAbsolutePath() + "' to interaction source.");
            }
            catch (ZipException e) {
                this.log.error("", e);
            }
            catch (IOException e) {
                this.log.error("", e);
            }
        }
        return new MultipleWrapper(multiple);
    }

    @Override
    protected int getCurrentUpdateHash() throws Exception {
        ArrayList<String> urls = new ArrayList<String>();
        for (String path : this.paths) {
            try {
                List<Object> files = IntActDiseaseUpdatePlugin.listFilesFromFtp(path);
                files = Lists.filter(files, this.zipFilter);
                files = Lists.head(files, 10);
                urls.addAll(files);
            }
            catch (Exception e) {
                this.exception = e;
            }
        }
        return this.computeHashCodeFromOnlineFiles(urls);
    }

    public static List<String> listFilesFromFtp(String args) throws SocketException, IOException {
        int groups;
        Matcher m = Pattern.compile("ftp://([^/]*)((/[^/]*)+)").matcher("");
        m.reset(args);
        ArrayList<String> files = new ArrayList<String>();
        if (m.matches() && (groups = m.groupCount()) > 2) {
            FTPClient client = new FTPClient();
            String prefix = m.group(0);
            String host = m.group(1);
            String path = m.group(2);
            client.connect(host);
            client.login("anonymous", "");
            client.enterLocalPassiveMode();
            if (client.changeWorkingDirectory(path)) {
                FTPListParseEngine engine = client.initiateListParsing();
                while (engine.hasNext()) {
                    FTPFile[] next;
                    for (FTPFile ftpFile : next = engine.getNext(100)) {
                        String filePath = prefix + ftpFile.getName();
                        files.add(filePath);
                    }
                }
            }
        }
        return files;
    }

    public static void main(String[] a) throws SocketException, IOException {
        String args = "ftp://ftp.ebi.ac.uk/pub/databases/intact/current/psi25/datasets/datasets/Cancer/";
        List<String> files = IntActDiseaseUpdatePlugin.listFilesFromFtp(args);
        for (String string : files) {
            System.out.println(string);
        }
    }
}

