/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update.plugin;

import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.parser.FileParsingException;
import de.berlin.hu.ppi.parser.PathwayAbsentParser;
import de.berlin.hu.ppi.parser.PathwayParser;
import de.berlin.hu.ppi.tool.FileTool;
import de.berlin.hu.ppi.update.AbstractPathwayUpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePlugin;
import de.berlin.hu.ppi.update.plugin.StorePathwaysInDB;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class InohPathwayUpdatePlugin
extends AbstractPathwayUpdatePlugin {
    private static UpdatePlugin instance = null;
    private static String HTTP_FILE_LOCATION_1 = "http://www.inoh.org/inohblog/main/BioPAX_level2/MetabolicPathwayBioPAX_l2_%s.zip";
    private static String HTTP_FILE_LOCATION_2 = "http://www.inoh.org/inohblog/main/BioPAX_level2/SignalTransductionPathwayBioPAX_l2_%s.zip";
    private static File target2;

    private InohPathwayUpdatePlugin() throws Exception {
        this.pluginName = "Inoh Pathways";
        this.description = "This plugin updates the Inoh data. INOH (Integrating Network Objects with Hierarchies) is a pathway database of model organisms including human, mouse, rat and others.";
        this.taskCount = 5;
        this.checkForUpdates();
    }

    public static UpdatePlugin getInstance() throws Exception {
        if (instance == null) {
            instance = new InohPathwayUpdatePlugin();
        }
        return instance;
    }

    @Override
    protected void runUpdate() throws Exception {
        File dir = this.setTargetDirectoryToTmpWithSubfolder();
        if (this.isInterrupted) {
            return;
        }
        this.startNextTask();
        this.setTaskDescription("Downloading");
        if (!dir.exists()) {
            this.log.error("", new IOException("Temporary directory for extracting biocyc xml files could not be created."));
        }
        SimpleDateFormat df = new SimpleDateFormat("yyMMdd");
        this.dateFetched.await();
        String url1 = String.format(HTTP_FILE_LOCATION_1, df.format(this.updateDate));
        String url2 = String.format(HTTP_FILE_LOCATION_2, df.format(this.updateDate));
        System.out.println("URL1: " + url1);
        System.out.println("URL2: " + url1);
        this.target = this.download(url1);
        this.startNextTask();
        this.setTaskDescription("Downloading");
        target2 = this.download(url2);
        this.startNextTask();
        this.setTaskDescription("Extracting");
        int sum = this.extractZip(this.target);
        this.startNextTask();
        this.setTaskDescription("Extracting");
        this.startNextTask();
        this.setTaskDescription("Parsing and Loading");
        this.setCounterFinish(2 * (sum += this.extractZip(target2)));
        this.db = StorePathwaysInDB.getInstance();
        this.db.establishConnection();
        this.db.deleteDataFromTables(PpiConstants.DB_ID.INOH);
        this.db.addSourceToDB(PpiConstants.DB_ID.INOH);
        this.db.closeConnection();
        if (!this.isInterrupted) {
            for (File file : FileTool.listAllFiles(dir)) {
                if (!file.getName().endsWith(".owl")) continue;
                if (this.isInterrupted) break;
                this.incrementCounter();
                PathwayParser parser = new PathwayParser(true);
                try {
                    System.out.println(file.getAbsolutePath());
                    parser.parseFile(file.getAbsolutePath());
                }
                catch (FileParsingException e) {
                    if (e.getMessage().equals("No pathway found")) {
                        parser = new PathwayAbsentParser(true);
                        parser.parseFile(file.getAbsolutePath());
                    }
                    throw e;
                }
                this.incrementCounter();
                this.db.establishConnection();
                int pathWaySize = parser.getPathwaysSize();
                this.log.info("Pathway-Size: " + pathWaySize);
                for (int i = 0; i < parser.getPathwaysSize() && !this.isInterrupted; ++i) {
                    this.db.loadPathwayIntoDb(parser.getPathway(i), this.uniquePathwayId++, null, PpiConstants.DB_ID.INOH);
                }
                this.db.closeConnection();
                this.db.storeNewTaxonIds();
            }
        }
        this.setUpdateTime("latestUpdate", this.updateDate);
    }

    @Override
    protected Date getUpdateDate() {
        try {
            return this.determineDate("last\\supdate", "http://www.inoh.org/download.html", PpiConstants.DB_ID.INOH, "yyyy.MM.dd", 0);
        }
        catch (Exception e) {
            this.log.error("", e);
            return null;
        }
    }
}

