/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update.plugin;

import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.update.AbstractUpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePlugin;
import de.berlin.hu.ppi.wrapper.ProteinInteraction;
import de.berlin.hu.ppi.wrapper.StaxWrapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public final class HprdUpdatePlugin
extends AbstractUpdatePlugin
implements PpiConstants {
    private static final String SEARCH_STRING = "HPRD_SINGLE_PSIMI_";
    private static final String URL_DOWNLOAD_SITE = "http://www.hprd.org/download";
    private static final int DOWNLOADING = 0;
    private static final int COUNTING_INTERACTIONS = 1;
    private static final int LOADING_INTERACTIONS = 2;
    private static UpdatePlugin instance;
    private File sourceFile;
    public static final String URL_DEFAULT = "http://www.hprd.org/edownload/HPRD_SINGLE_PSIMI_<version>";
    private List<String> urls = Arrays.asList("http://www.hprd.org/edownload/HPRD_SINGLE_PSIMI_<version>");

    private HprdUpdatePlugin() throws Exception {
        this.sourceId = PpiConstants.DB_ID.HPRD;
        this.taskCount = 3;
        this.taskDescriptions = new String[]{"Downloading", "Counting interactions.", "Loading HPRD data."};
        this.pluginName = "Human Protein Reference Database (HPRD)";
        this.description = "This plugin updates the PPI-data from '" + this.pluginName + "'.";
        this.log = Logger.getLogger(HprdUpdatePlugin.class);
        this.checkForUpdates();
    }

    @Override
    protected int getCurrentUpdateHash() throws Exception {
        String currentRelease = HprdUpdatePlugin.getCurrentRealeaseString();
        for (int i = 0; i < this.urls.size(); ++i) {
            this.urls.set(i, this.urls.get(i).replace("<version>", currentRelease));
        }
        return this.computeHashCodeFromOnlineFiles(this.urls);
    }

    public static UpdatePlugin getInstance() throws Exception {
        if (instance == null) {
            instance = new HprdUpdatePlugin();
        }
        return instance;
    }

    protected Iterable<ProteinInteraction> getInteractionSourceOld() {
        try {
            Process p = Runtime.getRuntime().exec("tar xvfO " + this.sourceFile.getAbsolutePath());
            return new StaxWrapper(p.getInputStream(), this.sourceFile.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Iterable<ProteinInteraction> getInteractionSource() {
        return this.getInteractionSourceOld();
    }

    @Override
    public void runUpdate() throws SQLException {
        if (!this.isInterrupted) {
            this.startTask(0);
            this.sourceFile = this.download(URL_DEFAULT.replace("<version>", HprdUpdatePlugin.getCurrentRealeaseString()));
        }
        int counted = 0;
        if (!this.isInterrupted) {
            this.startTask(1);
            counted = this.countingInteractions();
        }
        if (!this.isInterrupted) {
            this.startTask(2);
            this.loadingInteractions(counted);
        }
    }

    public static String getCurrentRealeaseString() {
        Logger log = Logger.getLogger(HprdUpdatePlugin.class);
        String output = "";
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(URL_DOWNLOAD_SITE).openStream()));
            String line = reader.readLine();
            while (line != null) {
                if (line.contains(SEARCH_STRING)) {
                    return line.split("HPRD_SINGLE_PSIMI_|[.]")[1];
                }
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            log.error("", e);
        }
        return output;
    }
}

