/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update.plugin;

import de.berlin.hu.ppi.parser.go.Go;
import de.berlin.hu.ppi.parser.go.GoTerm;
import de.berlin.hu.ppi.update.AbstractUpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePluginException;
import java.io.File;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

public final class GoUpdatePlugin
extends AbstractUpdatePlugin {
    private static final String GO_CONSIDER = "go_consider";
    private static final String GO_ALTERNATIVE_ID = "go_alternative_id";
    private static final String GO = "go";
    private static final int DOWNLOADING = 0;
    private static final int COUNTING_DATASETS = 1;
    private static final int LOADING_DATASETS = 2;
    private static final String URL_FILE = "http://www.geneontology.org/ontology/obo_format_1_2/gene_ontology.1_2.obo";
    private static final String GO_RELATIONSHIP = "go_relationship";
    private int countedDatasets = 0;
    private static UpdatePlugin instance;
    private File target;
    private List<String> urls = Arrays.asList("http://www.geneontology.org/ontology/obo_format_1_2/gene_ontology.1_2.obo");

    private GoUpdatePlugin() throws Exception {
        this.taskCount = 3;
        this.taskDescriptions = new String[]{"Downloading ", "Counting data sets...", "Loading data into database..."};
        this.pluginName = "Gene Ontology";
        this.description = "This plugin updates Gene Ontology data. The Gene Ontology project provides a controlled vocabulary to describe gene and gene product attributes in any organism.";
        this.checkForUpdates();
    }

    public static UpdatePlugin getInstance() throws Exception {
        if (instance == null) {
            instance = new GoUpdatePlugin();
        }
        return instance;
    }

    @Override
    public void reset() throws UpdatePluginException {
        super.reset();
        this.countedDatasets = 0;
    }

    @Override
    public void runUpdate() throws SQLException, IOException {
        if (!this.isInterrupted) {
            this.startTask(0);
            this.setTargetDirectoryToTmp();
            this.openDatabaseConnection();
            this.connection.setAutoCommit(false);
            this.target = this.download(URL_FILE);
        }
        if (!this.isInterrupted) {
            this.startTask(1);
            this.countingDatasets();
        }
        if (!this.isInterrupted) {
            this.startTask(2);
            this.laodingDatasets();
        }
    }

    private void laodingDatasets() throws SQLException, IOException {
        this.setCounterFinish(this.countedDatasets * 2);
        this.setTaskDescription("Parsing obo-file...");
        Go ontology = Go.parse(this.target);
        this.setTaskDescription("Doing some postprocessing...");
        ontology.doPostProcessing();
        PreparedStatement insertGo = this.connection.prepareStatement("INSERT INTO go VALUES (?,?,?,'0',?,?,?)");
        PreparedStatement insertGoObsolete = this.connection.prepareStatement("INSERT INTO go VALUES (?,?,?,'1',null,null,null)");
        PreparedStatement insertGoAlt = this.connection.prepareStatement("INSERT INTO go_alternative_id VALUES (?,?)");
        PreparedStatement insertGoConsider = this.connection.prepareStatement("INSERT INTO go_consider VALUES (?,?)");
        this.clearTables(GO_RELATIONSHIP, GO_ALTERNATIVE_ID, GO_CONSIDER, GO);
        int termCount = ontology.getTerms().size();
        for (GoTerm term : ontology.getTerms()) {
            this.setTaskDescription(String.format("Inserting GO-Terms (%d/%d)", this.getCurrentCounter(), termCount));
            if (term.isObsolete()) {
                insertGoObsolete.setString(1, term.getIdString());
                insertGoObsolete.setString(2, term.getName());
                insertGoObsolete.setString(3, Character.toString(term.getNamespace().getCharRepresentation()));
                insertGoObsolete.addBatch();
            } else {
                insertGo.setString(1, term.getIdString());
                insertGo.setString(2, term.getName());
                insertGo.setString(3, Character.toString(term.getNamespace().getCharRepresentation()));
                insertGo.setInt(4, term.getMinDepth());
                insertGo.setInt(5, term.getMaxDepth());
                insertGo.setDouble(6, term.getAvgDepth());
                insertGo.addBatch();
            }
            for (int considerId : term.getConsiderIds()) {
                insertGoConsider.setString(1, term.getIdString());
                insertGoConsider.setString(2, Go.toGoId(considerId));
                insertGoConsider.addBatch();
            }
            for (int altId : term.getAltIds()) {
                insertGoAlt.setString(1, term.getIdString());
                insertGoAlt.setString(2, Go.toGoId(altId));
                insertGoAlt.addBatch();
            }
            this.incrementCounter();
            if (this.getCurrentCounter() % 500L != 0L) continue;
            insertGo.executeBatch();
            insertGoObsolete.executeBatch();
            insertGoAlt.executeBatch();
            insertGoConsider.executeBatch();
        }
        insertGo.executeBatch();
        insertGoObsolete.executeBatch();
        insertGoAlt.executeBatch();
        insertGoConsider.executeBatch();
        PreparedStatement insertGoRelationship = this.connection.prepareStatement("INSERT INTO go_relationship VALUES (?,?,?)");
        for (GoTerm term : ontology.getTerms()) {
            for (GoTerm.Relationship rel : GoTerm.Relationship.values()) {
                for (int parent : term.getRelatingParents(rel)) {
                    insertGoRelationship.setString(1, term.getIdString());
                    insertGoRelationship.setString(2, Go.toGoId(parent));
                    insertGoRelationship.setString(3, rel.toString().toLowerCase());
                    insertGoRelationship.addBatch();
                }
            }
            this.incrementCounter();
            this.setTaskDescription(String.format("Inserting Go-Relationships (%d/%d)", this.getCurrentCounter() - (long)this.countedDatasets, this.countedDatasets));
            if (this.getCurrentCounter() % 500L != 0L) continue;
            insertGoRelationship.executeBatch();
        }
        insertGoRelationship.executeBatch();
        insertGo.close();
        insertGoAlt.close();
        insertGoConsider.close();
        insertGoRelationship.close();
    }

    private void countingDatasets() {
        try {
            this.setCounterFinish(Integer.parseInt(this.getProperty("dataCount")));
        }
        catch (Exception e) {
            this.setCounterFinish(1000L);
        }
        try {
            String line;
            this.openReader(this.target);
            this.countedDatasets = 0;
            while ((line = this.reader.readLine()) != null && !this.isInterrupted) {
                if (!line.matches("\\[Term\\].*")) continue;
                ++this.countedDatasets;
                this.incrementCounter();
            }
            this.reader.close();
        }
        catch (IOException e) {
            this.log.error(e);
            System.exit(0);
        }
        this.setProperty("dataCount", Integer.toString(this.countedDatasets));
    }

    @Override
    public UpdatePlugin.UpdateType getType() {
        return UpdatePlugin.UpdateType.META_DATA;
    }

    @Override
    protected int getCurrentUpdateHash() throws Exception {
        return this.computeHashCodeFromOnlineFiles(this.urls);
    }

    public static void main(String[] args) {
    }
}

