/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update.plugin;

import de.berlin.hu.ppi.parser.goa.Inserter;
import de.berlin.hu.ppi.update.AbstractUpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePluginException;
import de.berlin.hu.wbi.common.io.FastLineCounter;
import de.berlin.hu.wbi.common.io.IO;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public final class GoAnnotationsUpdatePlugin
extends AbstractUpdatePlugin {
    private static boolean skipDownload = false;
    private static final String dataPath = "/tmp/arzt/goa/";
    public static final EnumSet<Source> coveredSources = EnumSet.of(Source.mgi, new Source[]{Source.sgd, Source.fb, Source.wb, Source.rgd, Source.goa_human, Source.goa_uniprot});
    private static final String KEY_READ_LINES = "readLines";
    private static UpdatePlugin instance;
    private Inserter inserter;
    private int lineCount;

    private GoAnnotationsUpdatePlugin() throws Exception {
        this.taskCount = 1 + coveredSources.size();
        this.pluginName = "Go Annotations";
        this.description = "This update refreshes the go annotation data.";
        this.checkForUpdates();
    }

    public static UpdatePlugin getInstance() throws Exception {
        if (instance == null) {
            instance = new GoAnnotationsUpdatePlugin();
        }
        return instance;
    }

    @Override
    public void runUpdate() throws FileNotFoundException, IOException, SQLException {
        if (this.isInterrupted) {
            return;
        }
        Map<Source, String> fileMap = this.downloadFiles();
        if (this.isInterrupted) {
            return;
        }
        this.startNextTask("Retrieving relevant datasets");
        if (!this.isInterrupted) {
            this.startNextTask("Loading datasets.");
            this.connection = this.openDatabaseConnection();
            this.inserter = new Inserter(this.connection);
            for (Source source : fileMap.keySet()) {
                if (this.isInterrupted) break;
                this.setTaskDescription("Retrieving id mappings...");
                String id = source.name;
                Map<String, Integer> idMapping = this.inserter.getIdMapping(id);
                String locator = fileMap.get((Object)source);
                InputStream stream = IO.open(locator);
                if (stream != null && !this.isInterrupted) {
                    this.setTaskDescription("Performing " + (Object)((Object)source));
                    this.inserter.perform(stream, idMapping, source.name);
                }
                this.inserter.finish();
            }
            this.inserter = null;
        }
    }

    @Override
    public void cancel() throws UpdatePluginException {
        super.cancel();
        if (this.inserter != null) {
            this.inserter.interrupt();
        }
    }

    @Override
    public double getTaskProgress() {
        if (this.inserter != null) {
            double progress = (double)this.inserter.getCurrentLineNumber() / (double)this.lineCount;
            this.setTaskProgress(progress);
        }
        return super.getTaskProgress();
    }

    private Map<Source, String> downloadFiles() {
        HashMap<Source, String> map = new HashMap<Source, String>();
        this.lineCount = 0;
        for (Source source : coveredSources) {
            this.startNextTask();
            String locator = null;
            if (skipDownload) {
                locator = dataPath + source.filename;
            } else {
                String url = source.url + source.filename;
                File file = this.download(url);
                locator = file.getAbsolutePath();
            }
            this.setTaskDescription("Counting lines");
            BufferedReader read = IO.read(locator);
            try {
                this.lineCount += FastLineCounter.countLinesBufferdReader(read);
            }
            catch (IOException e) {
                // empty catch block
            }
            map.put(source, locator);
        }
        this.setProperty(KEY_READ_LINES, Integer.toString(this.lineCount));
        return map;
    }

    @Override
    public UpdatePlugin.UpdateType getType() {
        return UpdatePlugin.UpdateType.META_DATA;
    }

    public static String getFileName(URL url) {
        String[] file = url.getFile().split("[" + File.separator + "]");
        return file[file.length - 1];
    }

    @Override
    protected int getCurrentUpdateHash() throws Exception {
        ArrayList<String> urls = new ArrayList<String>(coveredSources.size());
        for (Source source : coveredSources) {
            String url = source.url + source.filename;
            urls.add(url);
        }
        return this.computeHashCodeFromOnlineFiles(urls);
    }

    public static enum Source {
        mgi("MGI", "ftp://ftp.geneontology.org/pub/go/gene-associations/", "gene_association.mgi.gz"),
        sgd("SGD", "ftp://ftp.geneontology.org/pub/go/gene-associations/", "gene_association.sgd.gz"),
        fb("FlyBase", "ftp://ftp.geneontology.org/pub/go/gene-associations/", "gene_association.fb.gz"),
        wb("WormBase", "ftp://ftp.geneontology.org/pub/go/gene-associations/", "gene_association.wb.gz"),
        rgd("RGD", "ftp://ftp.geneontology.org/pub/go/gene-associations/", "gene_association.rgd.gz"),
        goa_human("GoaHuman", "ftp://ftp.ebi.ac.uk/pub/databases/GO/goa/HUMAN/", "gene_association.goa_human.gz"),
        goa_uniprot("GoaUniProt", "ftp://ftp.ebi.ac.uk/pub/databases/GO/goa/UNIPROT/", "gene_association.goa_uniprot.gz");

        public String name;
        public String url;
        public String filename;

        private Source(String name, String url, String filename) {
            this.name = name;
            this.url = url;
            this.filename = filename;
        }
    }
}

