/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update.plugin;

import de.berlin.hu.ppi.PpiToolkit;
import de.berlin.hu.ppi.update.AbstractUpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.zip.GZIPInputStream;

public final class GoAnnotationsOldUpdatePlugin
extends AbstractUpdatePlugin {
    private static final String DESCRIPTION_TASK_1 = "Retrieving relevant datasets";
    private static final String GO_REL = "go_rel";
    private static final String GO_REL_EVIDENCE_ADD = "go_rel_evidence_add";
    private static final String GO_REL_EVIDENCE = "go_rel_evidence";
    private static final String KEY_READ_LINES = "readLines";
    private static final int EVIDENCE = 3;
    private static final int GO_ID = 2;
    private static final int DB_PID = 1;
    private static final int DB_NAME = 0;
    private static UpdatePlugin instance;
    private List<String[]> rowList;
    private List<File> files;
    private static final String getGoLinksQuery = "select * from (select r.id ref_id, m.id molecule_id from reference r, molecule m where r.molecule_id = m.id and r.db = 'org_specific_id' union select primary_uniprot_id ref_id, id molecule_id from molecule) result";
    private static final String DESCRIPTION_TASK_2 = "Loading datasets.";
    private List<String> urls = Arrays.asList("ftp://ftp.geneontology.org/pub/go/gene-associations/gene_association.mgi.gz", "ftp://ftp.geneontology.org/pub/go/gene-associations/gene_association.sgd.gz", "ftp://ftp.geneontology.org/pub/go/gene-associations/gene_association.fb.gz", "ftp://ftp.geneontology.org/pub/go/gene-associations/gene_association.wb.gz", "ftp://ftp.geneontology.org/pub/go/gene-associations/gene_association.rgd.gz", "ftp://ftp.geneontology.org/pub/go/gene-associations/gene_association.goa_uniprot.gz");

    private GoAnnotationsOldUpdatePlugin() throws Exception {
        this.taskCount = 1 + this.urls.size();
        this.pluginName = "Go Annotations";
        this.description = "This update refreshes the go annotations data.";
        this.checkForUpdates();
    }

    public static UpdatePlugin getInstance() throws Exception {
        if (instance == null) {
            instance = new GoAnnotationsOldUpdatePlugin();
        }
        return instance;
    }

    @Override
    public void runUpdate() throws FileNotFoundException, IOException, SQLException {
        if (this.isInterrupted) {
            return;
        }
        this.downloadFiles();
        if (this.isInterrupted) {
            return;
        }
        this.startNextTask(DESCRIPTION_TASK_1);
        this.countDatasetsNew();
        if (!this.isInterrupted) {
            this.startNextTask(DESCRIPTION_TASK_2);
            this.loadDatasets();
        }
    }

    private void downloadFiles() {
        this.startNextTask();
        this.files = new ArrayList<File>(this.urls.size());
        for (String url : this.urls) {
            if (this.isInterrupted) break;
            try {
                File file = this.download(url);
                this.files.add(file);
            }
            catch (Exception e) {
                this.log.warn("", e);
            }
        }
        System.out.println("Files: " + this.files);
    }

    private void loadDatasets() throws SQLException {
        this.openDatabaseConnection();
        this.connection.setAutoCommit(false);
        this.clearTables(GO_REL_EVIDENCE_ADD);
        this.setCounterFinish(this.rowList.size());
        this.log.info("Retrieving database ids possibly linking to a Go annotation...");
        ResultSet result = this.connection.prepareStatement(getGoLinksQuery).executeQuery();
        HashMap<String, Integer> ids = new HashMap<String, Integer>();
        while (result.next() && !this.isInterrupted) {
            String db_id = result.getString(1);
            if (db_id == null) continue;
            ids.put(db_id, result.getInt(2));
        }
        result.close();
        this.log.info(ids.size() + " datasets collected.");
        int insertGoRelEvidenceCount = 0;
        PreparedStatement insertGoRelEvidenceAdd = this.connection.prepareStatement("insert ignore into go_rel_evidence_add values(?,?,?,?)");
        for (String[] row : this.rowList) {
            if (this.isInterrupted) {
                return;
            }
            this.incrementCounter();
            if (ids.keySet().contains(row[1])) {
                String dbName = row[0].equals("UniProtKB") ? "uniprot" : row[0];
                insertGoRelEvidenceAdd.setString(1, row[2]);
                insertGoRelEvidenceAdd.setInt(2, (Integer)ids.get(row[1]));
                insertGoRelEvidenceAdd.setString(3, row[3]);
                insertGoRelEvidenceAdd.setString(4, dbName);
                insertGoRelEvidenceAdd.addBatch();
                if (++insertGoRelEvidenceCount % this.getBatchSize() == 0) {
                    insertGoRelEvidenceAdd.executeBatch();
                }
            }
            if (!this.isInterrupted) continue;
            return;
        }
        insertGoRelEvidenceAdd.executeBatch();
        insertGoRelEvidenceAdd.close();
        Statement statement = this.connection.createStatement();
        this.setTaskDescription("Updating go_rel table...");
        statement.executeUpdate("delete from go_rel");
        statement.executeUpdate("insert ignore into go_rel select go_id, molecule_id from go_rel_evidence");
        statement.executeUpdate("insert ignore into go_rel select go_id, molecule_id from go_rel_evidence_add");
        this.log.info("Updating go_rel table");
    }

    @Override
    public UpdatePlugin.UpdateType getType() {
        return UpdatePlugin.UpdateType.META_DATA;
    }

    public static String getFileName(URL url) {
        String[] file = url.getFile().split("[" + File.separator + "]");
        return file[file.length - 1];
    }

    @Override
    protected int getCurrentUpdateHash() throws Exception {
        return this.computeHashCodeFromOnlineFiles(this.urls);
    }

    private void countDatasetsNew() throws FileNotFoundException, IOException {
        Scanner scanner;
        this.setTaskDescription("Counting lines");
        int lineCount = 0;
        for (File file : this.files) {
            scanner = new Scanner(new GZIPInputStream(new FileInputStream(file)));
            while (scanner.hasNextLine()) {
                scanner.nextLine();
                this.setTaskDescription("Counting lines (" + ++lineCount + ")");
            }
        }
        System.out.println("Line count " + lineCount);
        this.setCounterFinish(lineCount);
        this.rowList = new ArrayList<String[]>();
        this.setTaskStartTime();
        this.setTaskDescription("Parsing data...");
        for (File file : this.files) {
            if (this.isInterrupted) break;
            this.log.info("performing file " + file.getAbsolutePath());
            scanner = new Scanner(new GZIPInputStream(new FileInputStream(file)));
            while (scanner.hasNextLine() && !this.isInterrupted) {
                String line = scanner.nextLine();
                if (!line.startsWith("!")) {
                    String[] fields = line.split("\\t");
                    String taxon = fields[12];
                    if (PpiToolkit.isRelevantTaxId(taxon = taxon.split("[:|]")[1])) {
                        String[] row = new String[]{fields[0], fields[1], fields[4], fields[6]};
                        this.rowList.add(row);
                    }
                }
                this.incrementCounter();
            }
        }
        if (!this.isInterrupted) {
            this.setProperty(KEY_READ_LINES, Integer.toString(lineCount));
        }
    }
}

