/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update.plugin;

import de.berlin.hu.ppi.update.AbstractUpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipFile;

public final class GadUpdatePlugin
extends AbstractUpdatePlugin {
    private static final String GAD_REL = "gad_rel";
    private static final String GAD_OMIM = "gad_omim";
    private static final String GAD = "gad";
    private static final String KEY_COUNTED_DATASETS_1 = "counted_datasets_1";
    private static final int DOWNLOADING = 0;
    private static final int COUNTING_DATASETS = 1;
    private static final int PARSING_DATASETS = 2;
    private static final int LOADING_DATASETS_1 = 3;
    private static final int LOADING_DATASETS_2 = 4;
    private static final String URL_FILE = "http://geneticassociationdb.nih.gov/all.xls.zip";
    private static UpdatePlugin instance;
    private Properties[] entries;
    private Set<String> seen = new HashSet<String>();
    private Set<String> seen_omim = new HashSet<String>();
    private Map<String, String> seen_names = new HashMap<String, String>();
    private Map<String, Integer> seen_assocs = new HashMap<String, Integer>();
    private Map<String, Integer> assigned_ids = new HashMap<String, Integer>();
    private File sourceFile;
    private int dataCount;
    private List<String> urls = Arrays.asList("http://geneticassociationdb.nih.gov/all.xls.zip");

    private GadUpdatePlugin() throws Exception {
        this.taskCount = 5;
        this.taskDescriptions = new String[]{"Downloading Gad...", "Counting data sets...", "Parsing data ...", "Loading data into database (phase 1) ...", "Loading data into database (phase 2) ..."};
        this.pluginName = "Gad";
        this.description = "This plugin updates Gad data. The Genetic Association Database is an archive of human genetic association studies of complex diseases and disorders. The goal of this database is to allow the user to rapidly identify medically relevant polymorphism from the large volume of polymorphism and mutational data, in the context of standardized nomenclature.";
        this.checkForUpdates();
    }

    public static UpdatePlugin getInstance() throws Exception {
        if (instance == null) {
            instance = new GadUpdatePlugin();
        }
        return instance;
    }

    @Override
    public void runUpdate() throws SQLException {
        this.openDatabaseConnection();
        this.connection.setAutoCommit(false);
        this.clearTables(GAD_OMIM, GAD_REL, GAD);
        this.startTask(0);
        this.setTargetDirectoryToTmp();
        this.sourceFile = this.download(URL_FILE);
        if (this.isInterrupted) {
            return;
        }
        this.startTask(1);
        this.countingDatasets();
        if (this.isInterrupted) {
            return;
        }
        this.startTask(2);
        this.parsingDatasets();
        if (this.isInterrupted) {
            return;
        }
        this.startTask(3);
        this.loadingDatasets1();
        if (this.isInterrupted) {
            return;
        }
        this.startTask(4);
        this.loadingDatasets2();
    }

    private void loadingDatasets2() throws SQLException {
        int insertCount = 0;
        PreparedStatement insertGadRel = this.connection.prepareStatement("INSERT INTO gad_rel VALUES (?,?,?,?,?)");
        this.setCounterFinish(this.seen.size());
        for (String key_base : this.seen) {
            if (this.isInterrupted) {
                return;
            }
            Integer gad_id = this.assigned_ids.get(this.seen_names.get(key_base + "pheno"));
            if (gad_id == null) continue;
            insertGadRel.setInt(1, gad_id);
            insertGadRel.setString(2, this.seen_names.get(key_base + "locnum"));
            insertGadRel.setInt(3, this.seen_assocs.get(key_base + "Y"));
            insertGadRel.setInt(4, this.seen_assocs.get(key_base + "N"));
            insertGadRel.setInt(5, this.seen_assocs.get(key_base + "X"));
            insertGadRel.addBatch();
            if (++insertCount % this.getBatchSize() == 0) {
                insertGadRel.executeBatch();
            }
            this.incrementCounter();
        }
        insertGadRel.executeBatch();
        insertGadRel.close();
    }

    private void loadingDatasets1() throws SQLException {
        this.setCounterFinish(this.dataCount);
        int idCount = 0;
        PreparedStatement insertGad = this.connection.prepareStatement("INSERT INTO gad VALUES (?,?,?)");
        PreparedStatement insertGadOmim = this.connection.prepareStatement("INSERT INTO gad_omim VALUES (?,?)");
        for (int i = 0; i < this.entries.length && !this.isInterrupted && this.entries[i] != null; ++i) {
            String omimID;
            String pk_base = this.entries[i].getProperty("Broad Phenotype") + this.entries[i].getProperty("Disease Class");
            Integer thisId = this.assigned_ids.get(pk_base);
            if (thisId == null) {
                thisId = ++idCount;
                insertGad.setInt(1, thisId);
                insertGad.setString(2, this.entries[i].getProperty("Disease Class"));
                insertGad.setString(3, this.entries[i].getProperty("Broad Phenotype"));
                insertGad.addBatch();
                if (i % this.getBatchSize() == 0) {
                    insertGad.executeBatch();
                    insertGadOmim.executeBatch();
                }
                this.assigned_ids.put(pk_base, thisId);
            }
            if ((omimID = this.entries[i].getProperty("OMIM ID")) != null && !omimID.isEmpty() && !this.seen_omim.contains(thisId + "--" + omimID)) {
                this.seen_omim.add(thisId + "--" + omimID);
                try {
                    insertGadOmim.setInt(1, thisId);
                    insertGadOmim.setInt(2, Integer.parseInt(omimID.trim()));
                    insertGadOmim.addBatch();
                }
                catch (Exception e) {
                    this.log.error("", e);
                }
            }
            this.incrementCounter();
            String locusNumber = this.entries[i].getProperty("Locus Number");
            if (locusNumber == null || locusNumber.isEmpty()) continue;
            String key_base = this.entries[i].getProperty("Broad Phenotype") + this.entries[i].getProperty("Disease Class") + this.entries[i].getProperty("Locus Number");
            this.seen.add(key_base);
            this.seen_names.put(key_base + "pheno", this.entries[i].getProperty("Broad Phenotype") + this.entries[i].getProperty("Disease Class"));
            this.seen_names.put(key_base + "locnum", this.entries[i].getProperty("Locus Number"));
            if (this.seen_assocs.get(key_base + "Y") == null) {
                this.seen_assocs.put(key_base + "Y", 0);
            }
            if (this.seen_assocs.get(key_base + "N") == null) {
                this.seen_assocs.put(key_base + "N", 0);
            }
            if (this.seen_assocs.get(key_base + "X") == null) {
                this.seen_assocs.put(key_base + "X", 0);
            }
            if (this.seen_assocs.get(key_base + "statC") == null) {
                this.seen_assocs.put(key_base + "statC", 0);
            }
            if (this.seen_assocs.get(key_base + "statAC") == null) {
                this.seen_assocs.put(key_base + "statAC", 0);
            }
            if (this.seen_assocs.get(key_base + "statP") == null) {
                this.seen_assocs.put(key_base + "statP", 0);
            }
            if (this.seen_assocs.get(key_base + "statX") == null) {
                this.seen_assocs.put(key_base + "statX", 0);
            }
            if (this.entries[i].getProperty("Association(Y/N)").equals("y")) {
                this.seen_assocs.put(key_base + "Y", this.seen_assocs.get(key_base + "Y") + 1);
                continue;
            }
            if (this.entries[i].getProperty("Association(Y/N)").equals("n")) {
                this.seen_assocs.put(key_base + "N", this.seen_assocs.get(key_base + "N") + 1);
                continue;
            }
            this.seen_assocs.put(key_base + "X", this.seen_assocs.get(key_base + "X") + 1);
        }
        if (this.isInterrupted) {
            return;
        }
        insertGad.executeBatch();
        insertGadOmim.executeBatch();
        insertGad.close();
        insertGadOmim.close();
        int countedDatasets_2 = this.seen.size();
        this.setCounterFinish(countedDatasets_2);
    }

    private void parsingDatasets() {
        try {
            String line;
            this.setCounterFinish(this.dataCount);
            ZipFile zip = new ZipFile(this.sourceFile);
            BufferedReader reader = new BufferedReader(new InputStreamReader(zip.getInputStream(zip.getEntry("tmp/all.txt"))));
            while ((line = reader.readLine()) != null && !line.startsWith("ID")) {
            }
            String[] field_names = line.split("\\t");
            this.entries = new Properties[this.dataCount];
            int count = 0;
            while ((line = reader.readLine()) != null && !this.isInterrupted) {
                if (this.isInterrupted) {
                    reader.close();
                    return;
                }
                String[] this_line = line.split("\\t");
                this.entries[count] = new Properties();
                for (int i = 0; i < field_names.length && i < this_line.length; ++i) {
                    this.entries[count].setProperty(field_names[i], this_line[i].toLowerCase().trim());
                }
                ++count;
                this.incrementCounter();
            }
        }
        catch (Exception e) {
            this.log.error("", e);
        }
    }

    private void countingDatasets() {
        this.dataCount = 0;
        String oldCountString = this.getProperty(KEY_COUNTED_DATASETS_1);
        int oldCount = 0;
        oldCount = oldCountString == null || oldCountString.isEmpty() ? 39930 : Integer.parseInt(oldCountString);
        this.setCounterFinish(oldCount);
        try {
            String line;
            ZipFile zip = new ZipFile(this.sourceFile);
            BufferedReader reader = new BufferedReader(new InputStreamReader(zip.getInputStream(zip.getEntry("tmp/all.txt"))));
            while ((line = reader.readLine()) != null && !line.startsWith("ID")) {
            }
            while ((line = reader.readLine()) != null && !this.isInterrupted) {
                this.incrementCounter();
                ++this.dataCount;
            }
            reader.close();
            if (this.isInterrupted) {
                return;
            }
        }
        catch (IOException e) {
            this.log.error("", e);
            System.exit(0);
        }
        this.setProperty(KEY_COUNTED_DATASETS_1, Integer.toString(this.dataCount));
        this.log.info("Counted Datasets: " + this.dataCount);
    }

    @Override
    public UpdatePlugin.UpdateType getType() {
        return UpdatePlugin.UpdateType.META_DATA;
    }

    @Override
    protected int getCurrentUpdateHash() throws Exception {
        return this.computeHashCodeFromOnlineFiles(this.urls);
    }
}

