/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update.plugin;

import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.PpiToolkit;
import de.berlin.hu.ppi.SourceFactory;
import de.berlin.hu.ppi.tool.FileTool;
import de.berlin.hu.ppi.update.AbstractUpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePlugin;
import de.berlin.hu.ppi.wrapper.ProteinInteraction;
import java.io.File;
import java.sql.SQLException;
import java.util.Arrays;

public final class DipUpdatePlugin
extends AbstractUpdatePlugin {
    private static final int COUNTING_INTERACTIONS = 0;
    private static final int LOADING_INTERACTIONS = 1;
    private static final String KEY_SOURCE = "sourceFile";
    private static final String VALUE_SOURCE = "/vol/home-vol3/wbi/wbi_stud/ppi_data/dip/dip20080708.xml";
    protected static UpdatePlugin instance;

    private DipUpdatePlugin() throws Exception {
        this.sourceId = PpiConstants.DB_ID.DIP;
        this.taskCount = 2;
        this.taskDescriptions = new String[]{"Counting interactions.", "Loading DIP data."};
        this.pluginName = "DIP";
        this.description = "This plugin updates the PPI-data from 'DIP'";
    }

    public static UpdatePlugin getInstance() throws Exception {
        if (instance == null) {
            instance = new DipUpdatePlugin();
        }
        return instance;
    }

    @Override
    public Iterable<ProteinInteraction> getInteractionSource() {
        File ppiDataPath = new File(PpiToolkit.getPpiDataPath(), "dip/");
        File[] files = ppiDataPath.listFiles();
        Arrays.sort(files, FileTool.FILE_DATE_COMPARATOR);
        File source = files[0];
        this.log.info("Using file: " + source.getAbsolutePath());
        Iterable<ProteinInteraction> output = null;
        output = source.exists() && !source.isDirectory() && source.length() > 0L ? (source.getName().endsWith(".gz") ? SourceFactory.getPpiWrapperGZip(source) : SourceFactory.getPpiWrapper(source)) : super.getInteractionSource();
        return output;
    }

    @Override
    public void runUpdate() throws SQLException {
        int counted = 0;
        if (!this.isInterrupted) {
            this.startTask(0);
            counted = this.countingInteractions();
        }
        if (!this.isInterrupted) {
            this.startTask(1);
            this.loadingInteractions(counted);
        }
    }

    @Override
    protected int getCurrentUpdateHash() {
        return 0;
    }

    public static void main(String[] args) throws Exception {
        PpiToolkit.setupEnvironment();
        DipUpdatePlugin dipUpdatePlugin = new DipUpdatePlugin();
        Iterable<ProteinInteraction> interactionSource = dipUpdatePlugin.getInteractionSource();
        System.out.println(interactionSource);
    }
}

