/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update.plugin;

import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.update.AbstractUpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePlugin;
import de.berlin.hu.ppi.wrapper.MultipleWrapper;
import de.berlin.hu.ppi.wrapper.ProteinInteraction;
import de.berlin.hu.ppi.wrapper.ZipInteractionIterator;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;

public final class BioGridUpdatePlugin
extends AbstractUpdatePlugin
implements PpiConstants {
    private static final String URL_BIO_GRID_SITE = "http://www.thebiogrid.org/index.php";
    private static final int DOWNLOADING = 0;
    private static final int COUNTING_INTERACTIONS = 1;
    private static final int LOADING_INTERACTIONS = 2;
    private static final String URL_BIO_GRID_FILE = "http://thebiogrid.org/downloads/archives/Release%20Archive/BIOGRID-<version>/BIOGRID-ALL-<version>.psi25.zip";
    private static UpdatePlugin instance;
    private File downloadedFile;
    private String urlString;
    private String version1;
    private String version2;

    private BioGridUpdatePlugin() throws Exception {
        this.sourceId = PpiConstants.DB_ID.BIOGRID;
        this.taskCount = 3;
        this.taskDescriptions = new String[]{"Downloading ", "Counting interactions.", "Loading BioGRID data."};
        this.pluginName = "BioGRID";
        this.description = "This plugin updates the PPI-data from  '" + this.pluginName + "'.";
        this.log = Logger.getLogger(BioGridUpdatePlugin.class);
        try {
            String release = this.getFilteredBiogridReleaseNumber();
            this.updateHash = release.hashCode();
            this.urlString = URL_BIO_GRID_FILE.replace("<version>", release);
        }
        catch (IOException e) {
            this.log.error("", e);
        }
        this.checkForUpdates();
    }

    public static UpdatePlugin getInstance() throws Exception {
        if (instance == null) {
            instance = new BioGridUpdatePlugin();
        }
        return instance;
    }

    @Override
    public void runUpdate() throws XPathExpressionException, IOException, SQLException {
        this.startTask(0);
        this.downloadedFile = this.download(this.urlString);
        int counted = 0;
        if (!this.isInterrupted) {
            this.startTask(1);
            counted = this.countingInteractions();
        }
        if (!this.isInterrupted) {
            this.startTask(2);
            this.loadingInteractions(counted);
        }
    }

    public String getFilteredBiogridReleaseNumber() throws IOException, InstantiationException {
        this.version1 = null;
        this.version2 = null;
        Runnable hack = new Runnable(){

            @Override
            public void run() {
                try {
                    BioGridUpdatePlugin.this.version1 = BioGridUpdatePlugin.getReleasNumber1();
                    BioGridUpdatePlugin.this.version2 = BioGridUpdatePlugin.getReleasNumber2();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        Thread versionFetcher = new Thread(hack);
        versionFetcher.start();
        try {
            versionFetcher.join(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.version1 != null) {
            if (this.version2 != null) {
                return this.version1.compareTo(this.version2) > 0 ? this.version1 : this.version2;
            }
            return this.version1;
        }
        throw new InstantiationException("Biogrid Site seems offline.");
    }

    public static String getReleasNumber1() throws IOException {
        URL url = new URL("http://wiki.thebiogrid.org/doku.php/statistics");
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        String line = reader.readLine();
        while (line != null) {
            String[] splitted;
            String version;
            if (line.contains("Current Build Statistics") && (version = (splitted = line.split("Current Build Statistics \\(|[)]"))[1]).matches("\\d[.]\\d[.]\\d\\d")) {
                return version;
            }
            line = reader.readLine();
        }
        return null;
    }

    public static String getReleasNumber2() throws IOException {
        URL url = new URL("http://wiki.thebiogrid.org/doku.php/statistics");
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        String line = reader.readLine();
        while (line != null && !line.contains("Current Build Statistics")) {
            line = reader.readLine();
        }
        line = reader.readLine();
        while (line != null) {
            String[] splitted;
            String version;
            if (line.contains("Current Build Statistics") && (version = (splitted = line.split("Current Build Statistics \\(|[)]"))[1]).matches("\\d[.]\\d[.]\\d\\d")) {
                return version;
            }
            line = reader.readLine();
        }
        return null;
    }

    @Override
    public Iterable<ProteinInteraction> getInteractionSource() {
        if (this.downloadedFile != null && this.downloadedFile.exists()) {
            MultipleWrapper output = null;
            try {
                output = new MultipleWrapper(new ZipInteractionIterator(new ZipFile(this.downloadedFile)));
            }
            catch (ZipException e) {
                this.log.error("", e);
            }
            catch (IOException e) {
                this.log.error("", e);
            }
            if (output == null) {
                this.log.error("Output was 'null'.");
            }
            return output;
        }
        return null;
    }

    public static String inputStreamToString(InputStream in) throws IOException {
        BufferedInputStream input = new BufferedInputStream(in);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[65535];
        int length = input.read(buffer);
        while (length > 0) {
            output.write(buffer, 0, length);
            length = input.read(buffer);
        }
        input.close();
        output.flush();
        output.close();
        return new String(output.toByteArray());
    }

    @Deprecated
    public static String getCurrentBiogridReleaseNumber2() throws MalformedURLException, IOException, XPathExpressionException {
        String[] splittet;
        XPath xpath = XPathFactory.newInstance().newXPath();
        InputSource source = new InputSource(new URL("http://www.thebiogrid.org/newsfeed/gridnews.xml").openStream());
        String test = (String)xpath.evaluate("//item[1]/title", source, XPathConstants.STRING);
        for (String s : splittet = test.split(" ")) {
            if (!s.matches("^\\d\\.\\d\\.\\d\\d$")) continue;
            return s;
        }
        return null;
    }

    @Deprecated
    public static String getCurrentBiogridReleaseNumber() throws IOException {
        HttpClient client = new HttpClient();
        GetMethod getmethod = new GetMethod(URL_BIO_GRID_SITE);
        int status = client.executeMethod(getmethod);
        if (status == 200) {
            int releaseindex;
            String df = BioGridUpdatePlugin.inputStreamToString(getmethod.getResponseBodyAsStream());
            String[] body = df.split("class=\"whatsnewheading\">Latest News</td>");
            if (body.length < 2) {
                throw new IOException("Section 'Lastest News' not found for scanning.");
            }
            df = body[1];
            int versionindex = df.indexOf("BioGRID Version ");
            String version = df.substring(versionindex + 16, releaseindex = df.indexOf(" Release", versionindex));
            if (!version.matches("^\\d\\.\\d\\.\\d\\d$")) {
                throw new IOException("Bad format of detected version number '" + version + "'.");
            }
            return version;
        }
        throw new IOException("BioGRID website (www.thebiogrid.org/index.php) returned bad status: " + status + ".");
    }

    @Override
    protected int getCurrentUpdateHash() {
        try {
            return this.getFilteredBiogridReleaseNumber().hashCode();
        }
        catch (Exception e) {
            this.log.warn("", e);
            return -1;
        }
    }
}

