/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update.plugin;

import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.parser.FileParsingException;
import de.berlin.hu.ppi.parser.PathwayAbsentParser;
import de.berlin.hu.ppi.parser.PathwayParser;
import de.berlin.hu.ppi.tool.FileTool;
import de.berlin.hu.ppi.tool.StringFilter;
import de.berlin.hu.ppi.update.AbstractPathwayUpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePlugin;
import de.berlin.hu.ppi.update.plugin.StorePathwaysInDB;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class BioCycPathwayUpdatePlugin
extends AbstractPathwayUpdatePlugin {
    private static UpdatePlugin instance = null;
    private static final String HTTP_FILE_LOCATION = "https://filex.ai.sri.com/brg/public/tier1-tier2-biopax.zip";
    private Map<String, String> organisms;

    private BioCycPathwayUpdatePlugin() throws Exception {
        this.pluginName = "BioCyc Pathways";
        this.description = "This plugin updates the BioCyc data. BioCyc is a collection of 505 Pathway/Genome Databases. Each database in the BioCyc collection describes the genome and metabolic pathways of a single organism.";
        this.organisms = new HashMap<String, String>();
        this.organisms.put("ecocyc", "Escherichia coli");
        this.organisms.put("agrocyc", "Agrobacterium tumefaciens C58");
        this.organisms.put("anthracyc", "Bacillus anthracis Ames");
        this.organisms.put("aurantimonascyc", "Aurantimonas sp. SI85-9A1");
        this.organisms.put("cattlecyc", "Bos taurus");
        this.organisms.put("caulocyc", "Caulobacter crescentus CB15");
        this.organisms.put("cparvumcyc", "Cryptosporidium parvum Iowa");
        this.organisms.put("ecol199310cyc", "Escherichia coli CFT073");
        this.organisms.put("ecoo157cyc", "Escherichia coli O157:H7EDL 933");
        this.organisms.put("frantcyc", "Francisella tularensis SCHU S4");
        this.organisms.put("hominiscyc", "Cryptosporidium hominis TU502");
        this.organisms.put("hpycyc", "Helicobacter pylori 26695");
        this.organisms.put("humancyc", "Homo sapiens");
        this.organisms.put("mousecyc", "Mus musculus");
        this.organisms.put("mtbcdccyc", "Mycobacterium tuberculosis CDC1551");
        this.organisms.put("mtbrvcyc", "Mycobacterium tuberculosis H37Rv");
        this.organisms.put("pbergheicyc", "Plasmodium berghei");
        this.organisms.put("pchabaudicyc", "Plasmodium chabaudi");
        this.organisms.put("plasmocyc", "Plasmodium falciparum 3D7");
        this.organisms.put("pvivaxcyc", "Plasmodium vivax Sal-1");
        this.organisms.put("pyoeliicyc", "Plasmodium yoelii 17XNL");
        this.organisms.put("shigellacyc", "Shigella flexneri 2457T");
        this.organisms.put("smancyc", "Schistosoma mansoni");
        this.organisms.put("toxocyc", "Toxoplasma gondii ME49");
        this.organisms.put("trypanocyc", "Trypanosoma brucei");
        this.organisms.put("vchocyc", "Vibrio cholerae O1 biovar El Tor str. N16961");
        this.organisms.put("yeastcyc", "Saccharomyces cerevisiae");
        this.taskCount = 2;
        this.checkForUpdates();
    }

    public static UpdatePlugin getInstance() throws Exception {
        if (instance == null) {
            instance = new BioCycPathwayUpdatePlugin();
        }
        return instance;
    }

    @Override
    protected void runUpdate() throws Exception {
        File dir = this.setTargetDirectoryToTmpWithSubfolder();
        if (this.isInterrupted) {
            return;
        }
        this.startNextTask();
        this.target = this.download(HTTP_FILE_LOCATION);
        if (this.isInterrupted) {
            return;
        }
        this.startNextTask();
        this.setTaskDescription("Extracting container");
        StringFilter filter = new StringFilter(){

            @Override
            public boolean acceptString(String s) {
                return s.toLowerCase().endsWith("2.owl");
            }
        };
        this.taskCount += this.extractZip(this.target, filter);
        dir = FileTool.asDirectory(this.target);
        if (this.isInterrupted) {
            return;
        }
        this.db = StorePathwaysInDB.getInstance();
        this.db.establishConnection();
        System.out.println("delete tables...");
        this.db.deleteDataFromTables(PpiConstants.DB_ID.BIOCYC);
        System.out.println("done.");
        this.db.addSourceToDB(PpiConstants.DB_ID.BIOCYC);
        this.db.closeConnection();
        if (!this.isInterrupted) {
            this.setTaskDescription("Parsing files");
            block2: for (File subdir : dir.listFiles()) {
                if (!subdir.isDirectory()) continue;
                for (File file : subdir.listFiles()) {
                    if (this.isInterrupted) continue block2;
                    this.startNextTask();
                    this.setTaskDescription("Loading data for species " + subdir.getName());
                    PathwayParser parser = new PathwayParser(true);
                    try {
                        System.out.println(file.getAbsolutePath());
                        parser.parseFile(file.getAbsolutePath());
                    }
                    catch (FileParsingException e) {
                        if (e.getMessage().equals("No pathway found")) {
                            parser = new PathwayAbsentParser(true);
                            parser.parseFile(file.getAbsolutePath());
                        }
                        throw e;
                    }
                    if (this.isInterrupted) continue;
                    this.db.establishConnection();
                    int pathWaySize = parser.getPathwaysSize();
                    this.log.info("Pathway-Size: " + pathWaySize);
                    this.setCounterFinish(pathWaySize);
                    for (int i = 0; i < parser.getPathwaysSize() && !this.isInterrupted; ++i) {
                        parser.getPathway(i).setOrganism(this.organisms.get(subdir.getName()));
                        this.db.loadPathwayIntoDb(parser.getPathway(i), this.uniquePathwayId++, null, PpiConstants.DB_ID.BIOCYC);
                        this.incrementCounter();
                    }
                    this.db.closeConnection();
                    this.db.storeNewTaxonIds();
                }
            }
        }
        this.dateFetched.await();
        this.setUpdateTime("latestUpdate", this.updateDate);
    }

    @Override
    protected Date getUpdateDate() {
        try {
            return this.determineDate("tier1-tier2-biopax.zip</a></td><td align=\"right\">", "https://filex.ai.sri.com/brg/public", PpiConstants.DB_ID.BIOCYC, "dd-MMM-yyyy HH:mm", 0);
        }
        catch (Exception e) {
            this.log.error("", e);
            return null;
        }
    }
}

