/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update;

import de.berlin.hu.ppi.PpiToolkit;
import de.berlin.hu.ppi.update.UpdatePlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class UpdatePluginManager {
    private static UpdatePluginManager instance = new UpdatePluginManager();
    private Set<UpdatePlugin> plugins;
    private Map<UpdatePlugin.UpdateType, List<UpdatePlugin>> updatePluginsByType;
    Logger log = Logger.getLogger(this.getClass());

    private UpdatePluginManager() {
        this.plugins = new HashSet<UpdatePlugin>();
    }

    public int loadPluginsFromUpdateProperties() {
        return this.loadPluginsFromProperty(PpiToolkit.getPiPaProperties());
    }

    public int loadPluginsFromProperty(Properties pluginProperties) {
        this.log.info("Loading Plugins.");
        String[] searchPath = pluginProperties.getProperty("ppi.update.pluginPaths").split("[|, :;]");
        return this.loadPluginsFrom(searchPath);
    }

    public int addUpdatePlugin(UpdatePlugin updatePlugin) {
        if (!this.plugins.contains(updatePlugin) && updatePlugin != null) {
            this.plugins.add(updatePlugin);
            return 1;
        }
        return 0;
    }

    public Collection<UpdatePlugin> getUpdatePlugins() {
        return this.plugins;
    }

    public Map<UpdatePlugin.UpdateType, List<UpdatePlugin>> getUpdatePluginsByType() {
        if (this.updatePluginsByType == null) {
            this.updatePluginsByType = new HashMap<UpdatePlugin.UpdateType, List<UpdatePlugin>>();
            for (UpdatePlugin updatePlugin : this.getUpdatePlugins()) {
                UpdatePlugin.UpdateType type = updatePlugin.getType();
                if (this.updatePluginsByType.get((Object)type) == null) {
                    this.updatePluginsByType.put(type, new ArrayList());
                }
                this.updatePluginsByType.get((Object)type).add(updatePlugin);
            }
            for (List list : this.updatePluginsByType.values()) {
                Comparator<UpdatePlugin> comparator = new Comparator<UpdatePlugin>(){

                    @Override
                    public int compare(UpdatePlugin o1, UpdatePlugin o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                };
                Collections.sort(list, comparator);
            }
        }
        return this.updatePluginsByType;
    }

    @Deprecated
    public UpdatePlugin getUpdatePlugin(int index) {
        return new ArrayList<UpdatePlugin>(this.plugins).get(index);
    }

    public void removeUpdatePlugin(UpdatePlugin updatePlugin) {
        this.plugins.remove(updatePlugin);
    }

    @Deprecated
    public boolean removeUpdatePlugin(int index) {
        ArrayList<UpdatePlugin> updatePlugins = new ArrayList<UpdatePlugin>(this.plugins);
        UpdatePlugin remove = (UpdatePlugin)updatePlugins.get(index);
        return this.plugins.remove(remove);
    }

    public int loadPlugins(Reader input) {
        int numberOfPlugins = 0;
        BufferedReader reader = new BufferedReader(input);
        String line = null;
        try {
            line = reader.readLine();
            while (line != null) {
                if (!line.startsWith("#") && !line.trim().isEmpty()) {
                    try {
                        UpdatePlugin currentPlugin = this.loadClass(line);
                        this.plugins.add(currentPlugin);
                        ++numberOfPlugins;
                    }
                    catch (Exception e) {
                        this.log.error("Could not add " + line + ". Required method not found: 'UpdatePlugin getInstance()'", e);
                    }
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            this.log.error("", e);
        }
        return numberOfPlugins;
    }

    private UpdatePlugin loadClass(String className) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(className);
        Method m = clazz.getMethod("getInstance", null);
        UpdatePlugin output = (UpdatePlugin)m.invoke(null, new Object[0]);
        return output;
    }

    public int loadPluginsFrom(String[] paths) {
        int pluginCount = 0;
        for (String path : paths) {
            for (File file : PpiToolkit.getAllFiles(path)) {
                String className = file.getPath();
                if (!(className = className.substring(path.length(), className.length())).endsWith(".class")) continue;
                className = className.substring(0, className.length() - 6);
                className = className.replace(File.separatorChar, '.');
                try {
                    UpdatePlugin newPlugin = this.loadClass(className);
                    this.plugins.add(newPlugin);
                    ++pluginCount;
                }
                catch (SecurityException e1) {
                    this.log.error("", e1);
                }
                catch (IllegalArgumentException e1) {
                    this.log.error("", e1);
                }
                catch (ClassNotFoundException e1) {
                    this.log.error("", e1);
                }
                catch (NoSuchMethodException e1) {
                    this.log.error("", e1);
                }
                catch (IllegalAccessException e1) {
                    this.log.error("", e1);
                }
                catch (InvocationTargetException e1) {
                    this.log.error("", e1);
                }
            }
        }
        return pluginCount;
    }

    public static UpdatePluginManager getInstance() {
        return instance;
    }

    public int loadPluginsFromRessource(String ressourceName) {
        return this.loadPlugins(new InputStreamReader(ClassLoader.getSystemResourceAsStream(ressourceName)));
    }

    public UpdatePlugin getUpdatePlugin(Class<?> clazz) {
        for (UpdatePlugin plugin : this.plugins) {
            if (!clazz.isInstance(plugin)) continue;
            return plugin;
        }
        return null;
    }
}

