/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update;

import de.berlin.hu.ppi.update.UpdatePluginException;
import java.util.Date;

public interface UpdatePlugin {
    public String getName();

    public String getDescription();

    public State getState();

    public void startUpdate() throws UpdatePluginException;

    public void cancel() throws UpdatePluginException;

    public boolean isUpdateAvailable();

    public double getProgress();

    public Date getLastUpdateTime();

    public String getTaskDescription();

    public double getTaskProgress();

    public void reset() throws UpdatePluginException;

    public UpdateType getType();

    public Exception getException();

    public void join();

    public static enum State {
        RESET,
        RUNNING,
        CANCELLED,
        DONE,
        ILLEGAL;

    }

    public static enum UpdateType {
        INTERACTION_DATA,
        META_DATA,
        PATHWAY_DATA,
        LOOKUP_TABLES,
        UNSPECIFIED;


        public String toString() {
            switch (this) {
                case INTERACTION_DATA: {
                    return "PPI-Data";
                }
                case META_DATA: {
                    return "Meta-Data";
                }
                case PATHWAY_DATA: {
                    return "Pathway-Data";
                }
                case UNSPECIFIED: {
                    return "Unspecified";
                }
                case LOOKUP_TABLES: {
                    return "Lookup-Tables";
                }
            }
            return "";
        }
    }
}

