/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.update;

import de.berlin.hu.ppi.db.DbService;
import de.berlin.hu.ppi.mediator.dbx.DBConnectionProvider;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import org.apache.log4j.Logger;

public class LockingManager {
    public static final String PROPERTIES = "client_properties";
    public static final String KEY = "property_key";
    public static final String VALUE = "property_value";
    private static LockingManager instance = null;
    private Logger log = Logger.getLogger(LockingManager.class);
    private Set<String> lockedByMe = new HashSet<String>();
    private Connection connection;
    private DBConnectionProvider dbConnectionProvider;

    private LockingManager(DBConnectionProvider dbConnectionProvider) throws Exception {
        this.dbConnectionProvider = dbConnectionProvider;
        this.connection = dbConnectionProvider == null ? DbService.getCurrentService().getNewConnection() : dbConnectionProvider.getNewConnection();
    }

    private void checkConnection() {
        try {
            if (!this.connection.isValid(1000)) {
                this.connection = this.dbConnectionProvider.getNewConnection();
            }
        }
        catch (Exception e) {
            this.log.error("", e);
        }
    }

    public static LockingManager getInstance() throws InstanceNotFoundException {
        if (instance == null) {
            throw new InstanceNotFoundException("Please Call 'instanciate' first!");
        }
        return instance;
    }

    public static LockingManager instanciate(DBConnectionProvider dbConnectionProvider) throws Exception {
        instance = new LockingManager(dbConnectionProvider);
        return instance;
    }

    public boolean isLocked(String id) throws SQLException {
        this.checkConnection();
        Statement statement = this.connection.createStatement();
        String sql = "SELECT * FROM client_properties WHERE property_key= '" + LockingManager.getKey(id) + "'";
        ResultSet result = statement.executeQuery(sql);
        return result.next();
    }

    public boolean lock(String id) {
        this.checkConnection();
        try {
            Statement statement = this.connection.createStatement();
            String sql = "INSERT INTO client_properties VALUES ('" + LockingManager.getKey(id) + "', '" + System.getProperty("user.name") + "')";
            statement.executeUpdate(sql);
            this.lockedByMe.add(id);
            return true;
        }
        catch (SQLException e) {
            this.log.error("", e);
            return false;
        }
    }

    public boolean unlock(String id) {
        this.checkConnection();
        try {
            Statement statement = this.connection.createStatement();
            String sql = "DELETE FROM client_properties WHERE property_key = '" + LockingManager.getKey(id) + "'";
            statement.executeUpdate(sql);
            this.lockedByMe.remove(id);
            return true;
        }
        catch (SQLException e) {
            this.log.error("", e);
            return false;
        }
    }

    public void clearSessionLocks() throws SQLException {
        this.checkConnection();
        this.log.info("Clearing all session locks...");
        for (String id : this.lockedByMe) {
            this.unlock(id);
        }
    }

    public Set<String> getLocks() throws SQLException {
        this.checkConnection();
        HashSet<String> output = new HashSet<String>();
        Statement statement = this.connection.createStatement();
        String sql = "SELECT * FROM client_properties where property_key like '%.lockedBy'";
        ResultSet result = statement.executeQuery(sql);
        while (result.next()) {
            String lock = result.getString(KEY);
            output.add(lock);
        }
        return Collections.unmodifiableSet(output);
    }

    public static String getKey(String id) {
        return id + ".lockedBy";
    }

    public void clearAllLocks() {
        this.checkConnection();
        try {
            Statement statement = this.connection.createStatement();
            String sql = "DELETE FROM client_properties where property_key like '%.lockedBy'";
            statement.execute(sql);
            statement.close();
        }
        catch (Exception e) {
            this.log.warn("", e);
        }
    }
}

